package io.polaris.core.consts;

/**
 * @author Qt
 * @since 1.8
 */
public interface CharConsts {

	/**
	 * 回车 Carriage Return
	 */
	char CR = '\r';
	/**
	 * 换行 Linefeed
	 */
	char LF = '\n';
	char TAB = '\t';
	/**
	 * 空格
	 */
	char SPACE = ' ';
	/**
	 * 波浪符
	 */
	char TILDE = '~';
	/**
	 * 反引号
	 */
	char BACKQUOTE = '`';
	/**
	 * 感叹号
	 */
	char EXCLAMATION_MARK = '!';
	/**
	 * at符号
	 */
	char AT_MARK = '@';
	/**
	 * #井号/散列符号/pound
	 */
	char HASH_MARK = '#';
	/**
	 * $美元符号
	 */
	char DOLLAR = '$';
	/**
	 * 百分号
	 */
	char PERCENT_MARK = '%';
	/**
	 * 脱字符/乘方符号
	 */
	char CARET = '^';
	/**
	 * &引用
	 */
	char AMPERSAND = '&';
	/**
	 * 星号
	 */
	char ASTERISK = '*';
	/**
	 * 连字号
	 */
	char HYPHEN = '-';
	char EQUALS = '=';
	/**
	 * 下划线
	 */
	char UNDERSCORE = '_';
	/**
	 * 点号
	 */
	char DOT = '.';
	/**
	 * 逗号
	 */
	char COMMA = ',';
	/**
	 * 分号
	 */
	char SEMICOLON = ';';
	/**
	 * 冒号
	 */
	char COLON = ':';
	/**
	 * 斜线
	 */
	char SLASH = '/';
	/**
	 * 反斜线
	 */
	char BACKSLASH = '\\';
	/**
	 * 问号
	 */
	char QUESTION_MARK = '?';
	/**
	 * 破折号
	 */
	char DASH = '-';
	/**
	 * 撇号
	 */
	char APOSTROPHE = '\'';
	/**
	 * 竖线
	 */
	char VERTICAL_BAR = '|';
	/**
	 * 双引号
	 */
	char DOUBLE_QUOTATION = '\"';
	/**
	 * 单引号
	 */
	char SINGLE_QUOTATION = '\'';
	/**
	 * 左花括号
	 */
	char LEFT_BRACE = '{';
	/**
	 * 右花括号
	 */
	char RIGHT_BRACE = '}';
	/**
	 * 左圆括号
	 */
	char LEFT_PARENTHESIS = '(';
	/**
	 * 右圆括号
	 */
	char RIGHT_PARENTHESIS = ')';
	/**
	 * 左方括号
	 */
	char LEFT_SQUARE_BRACKETS = '[';
	/**
	 * 右方括号
	 */
	char RIGHT_SQUARE_BRACKETS = ']';
	/**
	 * 左尖括号
	 */
	char LEFT_ANGLE_BRACKETS = '<';
	/**
	 * 右尖括号
	 */
	char RIGHT_ANGLE_BRACKETS = '>';

	char MINUS = HYPHEN;
	char PLUS = '+';
}
