/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.annotation.processing;

import io.polaris.core.annotation.Access;
import io.polaris.core.annotation.processing.AnnotationProcessorUtils;
import io.polaris.core.javapoet.ClassName;
import io.polaris.core.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class AccessBeanInfo {
    private TypeElement element;
    private boolean accessFields = false;
    private boolean accessFluent = false;
    private boolean accessMap = false;
    private boolean accessGetters = false;
    private boolean accessSetters = false;
    private Set<String> excludeFieldSet;
    private Set<String> excludeSetterSet;
    private Set<String> excludeGetterSet;
    private TypeName beanTypeName;
    private ClassName beanClassName;
    private ClassName fluentClassName;
    private ClassName fieldsClassName;
    private ClassName mapClassName;
    private ClassName gettersClassName;
    private ClassName settersClassName;
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();

    public AccessBeanInfo(TypeElement element) {
        this.element = element;
        this.init();
    }

    private void init() {
        Access access = this.element.getAnnotation(Access.class);
        if (access == null) {
            return;
        }
        this.accessFields = access.fields();
        this.accessFluent = access.fluent();
        this.accessMap = access.map();
        this.accessGetters = access.getters();
        this.accessSetters = access.setters();
        this.excludeFieldSet = new HashSet<String>();
        for (String s : access.excludeFields()) {
            this.excludeFieldSet.add(s);
        }
        this.excludeSetterSet = new HashSet<String>();
        for (String s : access.excludeSetters()) {
            this.excludeSetterSet.add(s);
        }
        this.excludeGetterSet = new HashSet<String>();
        for (String s : access.excludeGetters()) {
            this.excludeGetterSet.add(s);
        }
        String fluentSuffix = access.fluentSuffix();
        String fieldsSuffix = access.fieldsSuffix();
        String mapSuffix = access.mapSuffix();
        String gettersSuffix = access.gettersSuffix();
        String settersSuffix = access.settersSuffix();
        this.beanTypeName = TypeName.get(this.element.asType());
        this.beanClassName = ClassName.get(this.element);
        String simpleName = this.beanClassName.packageName().isEmpty() ? this.beanClassName.reflectionName() : this.beanClassName.reflectionName().substring(this.beanClassName.packageName().length() + 1);
        this.fluentClassName = ClassName.get(this.beanClassName.packageName(), simpleName + fluentSuffix, new String[0]);
        this.fieldsClassName = ClassName.get(this.beanClassName.packageName(), simpleName + fieldsSuffix, new String[0]);
        this.mapClassName = ClassName.get(this.beanClassName.packageName(), simpleName + mapSuffix, new String[0]);
        this.gettersClassName = ClassName.get(this.beanClassName.packageName(), simpleName + gettersSuffix, new String[0]);
        this.settersClassName = ClassName.get(this.beanClassName.packageName(), simpleName + settersSuffix, new String[0]);
        this.visitFieldElement(this.element);
    }

    private void visitFieldElement(TypeElement element) {
        HashSet<String> retrieved = new HashSet<String>();
        while (!Object.class.getName().equals(element.toString())) {
            TypeName declaredTypeName = TypeName.get(element.asType());
            ClassName declaredClassName = ClassName.get(element);
            for (Element element2 : element.getEnclosedElements()) {
                String fieldName;
                VariableElement variableElement;
                if (!(element2 instanceof VariableElement) || (variableElement = (VariableElement)element2).getKind() != ElementKind.FIELD || variableElement.getModifiers().contains((Object)Modifier.STATIC) || retrieved.contains(fieldName = variableElement.getSimpleName().toString())) continue;
                retrieved.add(fieldName);
                TypeName typeName = TypeName.get(variableElement.asType());
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.declaredTypeName = declaredTypeName;
                fieldInfo.declaredClassName = declaredClassName;
                fieldInfo.fieldName = fieldName;
                fieldInfo.typeName = typeName;
                fieldInfo.rawTypeName = AnnotationProcessorUtils.rawType(typeName);
                fieldInfo.getterName = AnnotationProcessorUtils.toGetterName(fieldName, typeName);
                fieldInfo.setterName = AnnotationProcessorUtils.toSetterName(fieldName);
                if (this.excludeFieldSet.contains(fieldName)) {
                    fieldInfo.accessField = false;
                } else {
                    fieldInfo.accessField = variableElement.getAnnotation(Access.ExcludeField.class) == null;
                }
                if (this.excludeSetterSet.contains(fieldName)) {
                    fieldInfo.accessSetter = false;
                } else {
                    fieldInfo.accessSetter = variableElement.getAnnotation(Access.ExcludeSetter.class) == null;
                }
                if (this.excludeGetterSet.contains(fieldName)) {
                    fieldInfo.accessGetter = false;
                } else {
                    fieldInfo.accessGetter = variableElement.getAnnotation(Access.ExcludeGetter.class) == null;
                }
                this.fields.add(fieldInfo);
            }
            TypeMirror typeMirror = element.getSuperclass();
            if (typeMirror instanceof NoType) break;
            element = (TypeElement)((DeclaredType)typeMirror).asElement();
        }
    }

    public TypeElement getElement() {
        return this.element;
    }

    public boolean isAccessFields() {
        return this.accessFields;
    }

    public boolean isAccessFluent() {
        return this.accessFluent;
    }

    public boolean isAccessMap() {
        return this.accessMap;
    }

    public boolean isAccessGetters() {
        return this.accessGetters;
    }

    public boolean isAccessSetters() {
        return this.accessSetters;
    }

    public Set<String> getExcludeFieldSet() {
        return this.excludeFieldSet;
    }

    public Set<String> getExcludeSetterSet() {
        return this.excludeSetterSet;
    }

    public Set<String> getExcludeGetterSet() {
        return this.excludeGetterSet;
    }

    public TypeName getBeanTypeName() {
        return this.beanTypeName;
    }

    public ClassName getBeanClassName() {
        return this.beanClassName;
    }

    public ClassName getFluentClassName() {
        return this.fluentClassName;
    }

    public ClassName getFieldsClassName() {
        return this.fieldsClassName;
    }

    public ClassName getMapClassName() {
        return this.mapClassName;
    }

    public ClassName getGettersClassName() {
        return this.gettersClassName;
    }

    public ClassName getSettersClassName() {
        return this.settersClassName;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public void setElement(TypeElement element) {
        this.element = element;
    }

    public void setAccessFields(boolean accessFields) {
        this.accessFields = accessFields;
    }

    public void setAccessFluent(boolean accessFluent) {
        this.accessFluent = accessFluent;
    }

    public void setAccessMap(boolean accessMap) {
        this.accessMap = accessMap;
    }

    public void setAccessGetters(boolean accessGetters) {
        this.accessGetters = accessGetters;
    }

    public void setAccessSetters(boolean accessSetters) {
        this.accessSetters = accessSetters;
    }

    public void setExcludeFieldSet(Set<String> excludeFieldSet) {
        this.excludeFieldSet = excludeFieldSet;
    }

    public void setExcludeSetterSet(Set<String> excludeSetterSet) {
        this.excludeSetterSet = excludeSetterSet;
    }

    public void setExcludeGetterSet(Set<String> excludeGetterSet) {
        this.excludeGetterSet = excludeGetterSet;
    }

    public void setBeanTypeName(TypeName beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public void setBeanClassName(ClassName beanClassName) {
        this.beanClassName = beanClassName;
    }

    public void setFluentClassName(ClassName fluentClassName) {
        this.fluentClassName = fluentClassName;
    }

    public void setFieldsClassName(ClassName fieldsClassName) {
        this.fieldsClassName = fieldsClassName;
    }

    public void setMapClassName(ClassName mapClassName) {
        this.mapClassName = mapClassName;
    }

    public void setGettersClassName(ClassName gettersClassName) {
        this.gettersClassName = gettersClassName;
    }

    public void setSettersClassName(ClassName settersClassName) {
        this.settersClassName = settersClassName;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessBeanInfo)) {
            return false;
        }
        AccessBeanInfo other = (AccessBeanInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.accessFields != other.accessFields) {
            return false;
        }
        if (this.accessFluent != other.accessFluent) {
            return false;
        }
        if (this.accessMap != other.accessMap) {
            return false;
        }
        if (this.accessGetters != other.accessGetters) {
            return false;
        }
        if (this.accessSetters != other.accessSetters) {
            return false;
        }
        TypeElement this$element = this.element;
        TypeElement other$element = other.element;
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        Set<String> this$excludeFieldSet = this.excludeFieldSet;
        Set<String> other$excludeFieldSet = other.excludeFieldSet;
        if (this$excludeFieldSet == null ? other$excludeFieldSet != null : !((Object)this$excludeFieldSet).equals(other$excludeFieldSet)) {
            return false;
        }
        Set<String> this$excludeSetterSet = this.excludeSetterSet;
        Set<String> other$excludeSetterSet = other.excludeSetterSet;
        if (this$excludeSetterSet == null ? other$excludeSetterSet != null : !((Object)this$excludeSetterSet).equals(other$excludeSetterSet)) {
            return false;
        }
        Set<String> this$excludeGetterSet = this.excludeGetterSet;
        Set<String> other$excludeGetterSet = other.excludeGetterSet;
        if (this$excludeGetterSet == null ? other$excludeGetterSet != null : !((Object)this$excludeGetterSet).equals(other$excludeGetterSet)) {
            return false;
        }
        TypeName this$beanTypeName = this.beanTypeName;
        TypeName other$beanTypeName = other.beanTypeName;
        if (this$beanTypeName == null ? other$beanTypeName != null : !((Object)this$beanTypeName).equals(other$beanTypeName)) {
            return false;
        }
        ClassName this$beanClassName = this.beanClassName;
        ClassName other$beanClassName = other.beanClassName;
        if (this$beanClassName == null ? other$beanClassName != null : !((Object)this$beanClassName).equals(other$beanClassName)) {
            return false;
        }
        ClassName this$fluentClassName = this.fluentClassName;
        ClassName other$fluentClassName = other.fluentClassName;
        if (this$fluentClassName == null ? other$fluentClassName != null : !((Object)this$fluentClassName).equals(other$fluentClassName)) {
            return false;
        }
        ClassName this$fieldsClassName = this.fieldsClassName;
        ClassName other$fieldsClassName = other.fieldsClassName;
        if (this$fieldsClassName == null ? other$fieldsClassName != null : !((Object)this$fieldsClassName).equals(other$fieldsClassName)) {
            return false;
        }
        ClassName this$mapClassName = this.mapClassName;
        ClassName other$mapClassName = other.mapClassName;
        if (this$mapClassName == null ? other$mapClassName != null : !((Object)this$mapClassName).equals(other$mapClassName)) {
            return false;
        }
        ClassName this$gettersClassName = this.gettersClassName;
        ClassName other$gettersClassName = other.gettersClassName;
        if (this$gettersClassName == null ? other$gettersClassName != null : !((Object)this$gettersClassName).equals(other$gettersClassName)) {
            return false;
        }
        ClassName this$settersClassName = this.settersClassName;
        ClassName other$settersClassName = other.settersClassName;
        if (this$settersClassName == null ? other$settersClassName != null : !((Object)this$settersClassName).equals(other$settersClassName)) {
            return false;
        }
        List<FieldInfo> this$fields = this.fields;
        List<FieldInfo> other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessBeanInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.accessFields ? 79 : 97);
        result = result * 59 + (this.accessFluent ? 79 : 97);
        result = result * 59 + (this.accessMap ? 79 : 97);
        result = result * 59 + (this.accessGetters ? 79 : 97);
        result = result * 59 + (this.accessSetters ? 79 : 97);
        TypeElement $element = this.element;
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        Set<String> $excludeFieldSet = this.excludeFieldSet;
        result = result * 59 + ($excludeFieldSet == null ? 43 : ((Object)$excludeFieldSet).hashCode());
        Set<String> $excludeSetterSet = this.excludeSetterSet;
        result = result * 59 + ($excludeSetterSet == null ? 43 : ((Object)$excludeSetterSet).hashCode());
        Set<String> $excludeGetterSet = this.excludeGetterSet;
        result = result * 59 + ($excludeGetterSet == null ? 43 : ((Object)$excludeGetterSet).hashCode());
        TypeName $beanTypeName = this.beanTypeName;
        result = result * 59 + ($beanTypeName == null ? 43 : ((Object)$beanTypeName).hashCode());
        ClassName $beanClassName = this.beanClassName;
        result = result * 59 + ($beanClassName == null ? 43 : ((Object)$beanClassName).hashCode());
        ClassName $fluentClassName = this.fluentClassName;
        result = result * 59 + ($fluentClassName == null ? 43 : ((Object)$fluentClassName).hashCode());
        ClassName $fieldsClassName = this.fieldsClassName;
        result = result * 59 + ($fieldsClassName == null ? 43 : ((Object)$fieldsClassName).hashCode());
        ClassName $mapClassName = this.mapClassName;
        result = result * 59 + ($mapClassName == null ? 43 : ((Object)$mapClassName).hashCode());
        ClassName $gettersClassName = this.gettersClassName;
        result = result * 59 + ($gettersClassName == null ? 43 : ((Object)$gettersClassName).hashCode());
        ClassName $settersClassName = this.settersClassName;
        result = result * 59 + ($settersClassName == null ? 43 : ((Object)$settersClassName).hashCode());
        List<FieldInfo> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "AccessBeanInfo(element=" + this.element + ", accessFields=" + this.accessFields + ", accessFluent=" + this.accessFluent + ", accessMap=" + this.accessMap + ", accessGetters=" + this.accessGetters + ", accessSetters=" + this.accessSetters + ", excludeFieldSet=" + this.excludeFieldSet + ", excludeSetterSet=" + this.excludeSetterSet + ", excludeGetterSet=" + this.excludeGetterSet + ", beanTypeName=" + this.beanTypeName + ", beanClassName=" + this.beanClassName + ", fluentClassName=" + this.fluentClassName + ", fieldsClassName=" + this.fieldsClassName + ", mapClassName=" + this.mapClassName + ", gettersClassName=" + this.gettersClassName + ", settersClassName=" + this.settersClassName + ", fields=" + this.fields + ")";
    }

    public static class FieldInfo {
        private TypeName declaredTypeName;
        private ClassName declaredClassName;
        private String fieldName;
        private TypeName typeName;
        private TypeName rawTypeName;
        private boolean accessGetter = true;
        private boolean accessSetter = true;
        private boolean accessField = true;
        private String setterName;
        private String getterName;

        public TypeName getDeclaredTypeName() {
            return this.declaredTypeName;
        }

        public ClassName getDeclaredClassName() {
            return this.declaredClassName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public TypeName getRawTypeName() {
            return this.rawTypeName;
        }

        public boolean isAccessGetter() {
            return this.accessGetter;
        }

        public boolean isAccessSetter() {
            return this.accessSetter;
        }

        public boolean isAccessField() {
            return this.accessField;
        }

        public String getSetterName() {
            return this.setterName;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public void setDeclaredTypeName(TypeName declaredTypeName) {
            this.declaredTypeName = declaredTypeName;
        }

        public void setDeclaredClassName(ClassName declaredClassName) {
            this.declaredClassName = declaredClassName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setTypeName(TypeName typeName) {
            this.typeName = typeName;
        }

        public void setRawTypeName(TypeName rawTypeName) {
            this.rawTypeName = rawTypeName;
        }

        public void setAccessGetter(boolean accessGetter) {
            this.accessGetter = accessGetter;
        }

        public void setAccessSetter(boolean accessSetter) {
            this.accessSetter = accessSetter;
        }

        public void setAccessField(boolean accessField) {
            this.accessField = accessField;
        }

        public void setSetterName(String setterName) {
            this.setterName = setterName;
        }

        public void setGetterName(String getterName) {
            this.getterName = getterName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.accessGetter != other.accessGetter) {
                return false;
            }
            if (this.accessSetter != other.accessSetter) {
                return false;
            }
            if (this.accessField != other.accessField) {
                return false;
            }
            TypeName this$declaredTypeName = this.declaredTypeName;
            TypeName other$declaredTypeName = other.declaredTypeName;
            if (this$declaredTypeName == null ? other$declaredTypeName != null : !((Object)this$declaredTypeName).equals(other$declaredTypeName)) {
                return false;
            }
            ClassName this$declaredClassName = this.declaredClassName;
            ClassName other$declaredClassName = other.declaredClassName;
            if (this$declaredClassName == null ? other$declaredClassName != null : !((Object)this$declaredClassName).equals(other$declaredClassName)) {
                return false;
            }
            String this$fieldName = this.fieldName;
            String other$fieldName = other.fieldName;
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            TypeName this$typeName = this.typeName;
            TypeName other$typeName = other.typeName;
            if (this$typeName == null ? other$typeName != null : !((Object)this$typeName).equals(other$typeName)) {
                return false;
            }
            TypeName this$rawTypeName = this.rawTypeName;
            TypeName other$rawTypeName = other.rawTypeName;
            if (this$rawTypeName == null ? other$rawTypeName != null : !((Object)this$rawTypeName).equals(other$rawTypeName)) {
                return false;
            }
            String this$setterName = this.setterName;
            String other$setterName = other.setterName;
            if (this$setterName == null ? other$setterName != null : !this$setterName.equals(other$setterName)) {
                return false;
            }
            String this$getterName = this.getterName;
            String other$getterName = other.getterName;
            return !(this$getterName == null ? other$getterName != null : !this$getterName.equals(other$getterName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.accessGetter ? 79 : 97);
            result = result * 59 + (this.accessSetter ? 79 : 97);
            result = result * 59 + (this.accessField ? 79 : 97);
            TypeName $declaredTypeName = this.declaredTypeName;
            result = result * 59 + ($declaredTypeName == null ? 43 : ((Object)$declaredTypeName).hashCode());
            ClassName $declaredClassName = this.declaredClassName;
            result = result * 59 + ($declaredClassName == null ? 43 : ((Object)$declaredClassName).hashCode());
            String $fieldName = this.fieldName;
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            TypeName $typeName = this.typeName;
            result = result * 59 + ($typeName == null ? 43 : ((Object)$typeName).hashCode());
            TypeName $rawTypeName = this.rawTypeName;
            result = result * 59 + ($rawTypeName == null ? 43 : ((Object)$rawTypeName).hashCode());
            String $setterName = this.setterName;
            result = result * 59 + ($setterName == null ? 43 : $setterName.hashCode());
            String $getterName = this.getterName;
            result = result * 59 + ($getterName == null ? 43 : $getterName.hashCode());
            return result;
        }

        public String toString() {
            return "AccessBeanInfo.FieldInfo(declaredTypeName=" + this.declaredTypeName + ", declaredClassName=" + this.declaredClassName + ", fieldName=" + this.fieldName + ", typeName=" + this.typeName + ", rawTypeName=" + this.rawTypeName + ", accessGetter=" + this.accessGetter + ", accessSetter=" + this.accessSetter + ", accessField=" + this.accessField + ", setterName=" + this.setterName + ", getterName=" + this.getterName + ")";
        }
    }
}

