/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.Advice;
import io.polaris.core.aop.Aspect;
import io.polaris.core.aop.ProxyFactory;
import io.polaris.core.aop.ProxyUtils;
import io.polaris.core.assertion.Assertions;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public class AsmProxyFactory
implements ProxyFactory {
    private final Object target;
    private final Aspect aspect;
    private Class<?> superclass;
    private Class<?>[] interfaces;
    private ClassLoader classloader;

    public AsmProxyFactory(Object target) {
        this.target = target;
        this.aspect = new Aspect(target, new Advice[0]);
        this.classloader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public AsmProxyFactory classloader(ClassLoader classloader) {
        this.classloader = classloader;
        return this;
    }

    @Override
    public AsmProxyFactory superclass(Class<?> superclass) {
        if (superclass != null) {
            Assertions.assertInstanceOf(superclass, this.target, "target type is not matched superclass");
        } else {
            superclass = this.target.getClass();
        }
        this.superclass = superclass;
        return this;
    }

    @Override
    public AsmProxyFactory interfaces(Class<?>[] interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    @Override
    public AsmProxyFactory addAdvice(Advice ... advices) {
        this.aspect.addAdvice(advices);
        return this;
    }

    @Override
    public AsmProxyFactory addAdvice(Predicate<Method> predicate, Advice ... advices) {
        this.aspect.addAdvice(predicate, advices);
        return this;
    }

    @Override
    public <T> T get() {
        return ProxyUtils.proxy(this.classloader, this.superclass == null ? this.target.getClass() : this.superclass, this.interfaces, this.aspect);
    }
}

