/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.AopProxy;
import io.polaris.core.aop.AsmProxyFactory;
import io.polaris.core.aop.JdkProxyFactory;
import io.polaris.core.aop.ProxyFactory;
import io.polaris.core.asm.proxy.Enhancer;
import io.polaris.core.asm.proxy.Interceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ProxyUtils {
    public static <T> ProxyFactory proxyFactory(Object target) {
        return new AsmProxyFactory(target);
    }

    public static <T> ProxyFactory jdkProxyFactory(Object target) {
        return new JdkProxyFactory(target);
    }

    public static <T> T proxy(Class<?> superclass, Class<?>[] interfaces, Interceptor interceptor) {
        return ProxyUtils.proxy(Thread.currentThread().getContextClassLoader(), superclass, interfaces, interceptor);
    }

    public static <T> T proxy(ClassLoader classloader, Class<?> superclass, Class<?>[] interfaces, Interceptor interceptor) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classloader);
        return (T)((Enhancer)((Enhancer)enhancer.superclass((Class)superclass)).interfaces((Class[])ProxyUtils.appendInterfaces(interfaces))).interceptor(interceptor).create();
    }

    public static <T> T jdkProxy(Class<?>[] interfaces, InvocationHandler handler) {
        return ProxyUtils.jdkProxy(null, interfaces, handler);
    }

    public static <T> T jdkProxy(ClassLoader classloader, Class<?>[] interfaces, InvocationHandler handler) {
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return (T)Proxy.newProxyInstance(classloader, ProxyUtils.appendInterfaces(interfaces), handler);
    }

    private static Class<?>[] appendInterfaces(Class<?>[] interfaces) {
        if (interfaces == null || interfaces.length == 0) {
            return new Class[]{AopProxy.class};
        }
        Class[] array = new Class[interfaces.length + 1];
        System.arraycopy(interfaces, 0, array, 0, interfaces.length);
        array[interfaces.length] = AopProxy.class;
        return array;
    }

    public static boolean isAopProxy(Object object) {
        return object instanceof AopProxy && (Proxy.isProxyClass(object.getClass()) || object.getClass().getName().contains("$$"));
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object instanceof AopProxy && Proxy.isProxyClass(object.getClass());
    }

    public static boolean isAsmDynamicProxy(Object object) {
        return object instanceof AopProxy && object.getClass().getName().contains("$$");
    }
}

