/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.generator;

import io.polaris.core.env.GlobalStdEnv;
import io.polaris.core.io.IO;
import io.polaris.core.string.Strings;
import io.polaris.dependency.org.objectweb.asm.ClassVisitor;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DebuggingClassWriter
extends ClassVisitor {
    private static final String classBytesCacheDir;
    private static final boolean classBytesCacheEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(int flags) {
        super(589824, new ClassWriter(flags));
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name.replace('/', '.');
        this.superName = superName.replace('/', '.');
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                byte[] b = ((ClassWriter)DebuggingClassWriter.this.cv).toByteArray();
                if (classBytesCacheEnabled) {
                    try {
                        IO.writeBytes(new File(classBytesCacheDir + File.separatorChar + DebuggingClassWriter.this.className.replace('.', File.separatorChar) + ".class"), b);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return b;
            }
        });
    }

    static {
        String tmpdir = GlobalStdEnv.get("java.class.bytes.tmpdir");
        if (Strings.isNotBlank(tmpdir)) {
            File dir = new File(tmpdir.trim());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            classBytesCacheDir = dir.getAbsolutePath();
            classBytesCacheEnabled = dir.exists();
        } else {
            classBytesCacheDir = null;
            classBytesCacheEnabled = false;
        }
    }
}

