/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.internal;

import io.polaris.core.asm.internal.AsmConsts;
import io.polaris.core.asm.internal.MethodInfo;
import io.polaris.core.asm.internal.Signature;
import io.polaris.core.javapoet.ArrayTypeName;
import io.polaris.core.javapoet.ClassName;
import io.polaris.core.javapoet.ParameterizedTypeName;
import io.polaris.core.javapoet.TypeName;
import io.polaris.core.javapoet.TypeVariableName;
import io.polaris.core.javapoet.WildcardTypeName;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.map.Maps;
import io.polaris.core.string.StringCases;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AsmTypes {
    private static final Map<String, String> transforms = new HashMap<String, String>();
    private static final Map<String, String> rtransforms = new HashMap<String, String>();

    public static String toTypeSignature(Type type) {
        if (type instanceof JavaType) {
            return AsmTypes.toTypeSignature(((JavaType)type).getRawType());
        }
        if (type instanceof Class) {
            if (((Class)type).isPrimitive()) {
                return io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Types.getWrapperClass((Class)type));
            }
            return io.polaris.dependency.org.objectweb.asm.Type.getDescriptor((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            sb.append("L").append(parameterizedType.getRawType().getTypeName().replace('.', '/'));
            sb.append("<");
            Type[] args = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                sb.append(AsmTypes.toTypeSignature(args[i]));
            }
            sb.append(">;");
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            if (lowerBounds.length > 0) {
                return "-" + AsmTypes.toTypeSignature(lowerBounds[0]);
            }
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length > 0) {
                return "+" + AsmTypes.toTypeSignature(upperBounds[0]);
            }
            return AsmTypes.toTypeSignature(Object.class);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            return "[" + AsmTypes.toTypeSignature(componentType);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static String toTypeSignature(TypeName typeName) {
        if (typeName instanceof ClassName) {
            if (typeName.isPrimitive()) {
                typeName = typeName.box();
            }
            return 'L' + ((ClassName)typeName).reflectionName().replace('.', '/') + ';';
        }
        if (typeName instanceof ParameterizedTypeName) {
            StringBuilder sb = new StringBuilder();
            sb.append("L").append(((ParameterizedTypeName)typeName).rawType.reflectionName().replace('.', '/'));
            sb.append("<");
            List<TypeName> typeArguments = ((ParameterizedTypeName)typeName).typeArguments;
            for (TypeName typeArgument : typeArguments) {
                sb.append(AsmTypes.toTypeSignature(typeArgument));
            }
            sb.append(">;");
            return sb.toString();
        }
        if (typeName instanceof WildcardTypeName) {
            List<TypeName> lowerBounds = ((WildcardTypeName)typeName).lowerBounds;
            if (lowerBounds != null && lowerBounds.size() > 0) {
                return "-" + AsmTypes.toTypeSignature(lowerBounds.get(0));
            }
            List<TypeName> upperBounds = ((WildcardTypeName)typeName).upperBounds;
            if (upperBounds != null && upperBounds.size() > 0) {
                return "+" + AsmTypes.toTypeSignature(upperBounds.get(0));
            }
            return io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(Object.class);
        }
        if (typeName instanceof ArrayTypeName) {
            TypeName componentType = ((ArrayTypeName)typeName).componentType;
            return "[" + AsmTypes.toTypeSignature(componentType);
        }
        if (typeName instanceof TypeVariableName) {
            throw new IllegalArgumentException("Unsupported typeName: " + typeName);
        }
        throw new IllegalArgumentException("Unsupported typeName: " + typeName);
    }

    public static io.polaris.dependency.org.objectweb.asm.Type getType(String className) {
        return io.polaris.dependency.org.objectweb.asm.Type.getType("L" + className.replace('.', '/') + ";");
    }

    public static boolean isFinal(int access) {
        return (0x10 & access) != 0;
    }

    public static boolean isStatic(int access) {
        return (8 & access) != 0;
    }

    public static boolean isProtected(int access) {
        return (4 & access) != 0;
    }

    public static boolean isPublic(int access) {
        return (1 & access) != 0;
    }

    public static boolean isAbstract(int access) {
        return (0x400 & access) != 0;
    }

    public static boolean isInterface(int access) {
        return (0x200 & access) != 0;
    }

    public static boolean isPrivate(int access) {
        return (2 & access) != 0;
    }

    public static boolean isSynthetic(int access) {
        return (0x1000 & access) != 0;
    }

    public static boolean isBridge(int access) {
        return (0x40 & access) != 0;
    }

    public static String getPackageName(io.polaris.dependency.org.objectweb.asm.Type type) {
        return AsmTypes.getPackageName(AsmTypes.getClassName(type));
    }

    public static String getPackageName(String className) {
        int idx = className.lastIndexOf(46);
        return idx < 0 ? "" : className.substring(0, idx);
    }

    public static String upperFirst(String s) {
        return StringCases.capitalize(s);
    }

    public static String getClassName(io.polaris.dependency.org.objectweb.asm.Type type) {
        if (AsmTypes.isPrimitive(type)) {
            return rtransforms.get(type.getDescriptor());
        }
        if (AsmTypes.isArray(type)) {
            return AsmTypes.getClassName(AsmTypes.getComponentType(type)) + "[]";
        }
        return type.getClassName();
    }

    public static io.polaris.dependency.org.objectweb.asm.Type[] add(io.polaris.dependency.org.objectweb.asm.Type[] types, io.polaris.dependency.org.objectweb.asm.Type extra) {
        if (types == null) {
            return new io.polaris.dependency.org.objectweb.asm.Type[]{extra};
        }
        if (Arrays.asList(types).contains(extra)) {
            return types;
        }
        io.polaris.dependency.org.objectweb.asm.Type[] copy = new io.polaris.dependency.org.objectweb.asm.Type[types.length + 1];
        System.arraycopy(types, 0, copy, 0, types.length);
        copy[types.length] = extra;
        return copy;
    }

    public static io.polaris.dependency.org.objectweb.asm.Type[] add(io.polaris.dependency.org.objectweb.asm.Type[] t1, io.polaris.dependency.org.objectweb.asm.Type[] t2) {
        io.polaris.dependency.org.objectweb.asm.Type[] all = new io.polaris.dependency.org.objectweb.asm.Type[t1.length + t2.length];
        System.arraycopy(t1, 0, all, 0, t1.length);
        System.arraycopy(t2, 0, all, t1.length, t2.length);
        return all;
    }

    public static io.polaris.dependency.org.objectweb.asm.Type fromInternalName(String name) {
        return io.polaris.dependency.org.objectweb.asm.Type.getType("L" + name + ";");
    }

    public static io.polaris.dependency.org.objectweb.asm.Type[] fromInternalNames(String[] names) {
        if (names == null) {
            return null;
        }
        io.polaris.dependency.org.objectweb.asm.Type[] types = new io.polaris.dependency.org.objectweb.asm.Type[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = AsmTypes.fromInternalName(names[i]);
        }
        return types;
    }

    public static int getStackSize(io.polaris.dependency.org.objectweb.asm.Type[] types) {
        int size = 0;
        for (int i = 0; i < types.length; ++i) {
            size += types[i].getSize();
        }
        return size;
    }

    public static String[] toInternalNames(io.polaris.dependency.org.objectweb.asm.Type[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public static Signature parseSignature(String s) {
        int space = s.indexOf(32);
        int lparen = s.indexOf(40, space);
        int rparen = s.indexOf(41, lparen);
        String returnType = s.substring(0, space);
        String methodName = s.substring(space + 1, lparen);
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator it = AsmTypes.parseTypes(s, lparen + 1, rparen).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        sb.append(')');
        sb.append(AsmTypes.map(returnType));
        return new Signature(methodName, sb.toString());
    }

    public static io.polaris.dependency.org.objectweb.asm.Type parseType(String s) {
        return io.polaris.dependency.org.objectweb.asm.Type.getType(AsmTypes.map(s));
    }

    public static io.polaris.dependency.org.objectweb.asm.Type[] parseTypes(String s) {
        List names = AsmTypes.parseTypes(s, 0, s.length());
        io.polaris.dependency.org.objectweb.asm.Type[] types = new io.polaris.dependency.org.objectweb.asm.Type[names.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = io.polaris.dependency.org.objectweb.asm.Type.getType((String)names.get(i));
        }
        return types;
    }

    public static Signature parseConstructor(io.polaris.dependency.org.objectweb.asm.Type[] types) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < types.length; ++i) {
            sb.append(types[i].getDescriptor());
        }
        sb.append(")");
        sb.append("V");
        return new Signature("<init>", sb.toString());
    }

    public static Signature parseConstructor(String sig) {
        return AsmTypes.parseSignature("void <init>(" + sig + ")");
    }

    private static List parseTypes(String s, int mark, int end) {
        int next;
        ArrayList<String> types = new ArrayList<String>(5);
        while ((next = s.indexOf(44, mark)) >= 0) {
            types.add(AsmTypes.map(s.substring(mark, next).trim()));
            mark = next + 1;
        }
        types.add(AsmTypes.map(s.substring(mark, end).trim()));
        return types;
    }

    private static String map(String type) {
        if (type.equals("")) {
            return type;
        }
        String t = transforms.get(type);
        if (t != null) {
            return t;
        }
        if (type.indexOf(46) < 0) {
            return AsmTypes.map("java.lang." + type);
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while ((index = type.indexOf("[]", index) + 1) > 0) {
            sb.append('[');
        }
        type = type.substring(0, type.length() - sb.length() * 2);
        sb.append('L').append(type.replace('.', '/')).append(';');
        return sb.toString();
    }

    public static io.polaris.dependency.org.objectweb.asm.Type getBoxedType(io.polaris.dependency.org.objectweb.asm.Type type) {
        switch (type.getSort()) {
            case 2: {
                return AsmConsts.TYPE_CHARACTER;
            }
            case 1: {
                return AsmConsts.TYPE_BOOLEAN;
            }
            case 8: {
                return AsmConsts.TYPE_DOUBLE;
            }
            case 6: {
                return AsmConsts.TYPE_FLOAT;
            }
            case 7: {
                return AsmConsts.TYPE_LONG;
            }
            case 5: {
                return AsmConsts.TYPE_INTEGER;
            }
            case 4: {
                return AsmConsts.TYPE_SHORT;
            }
            case 3: {
                return AsmConsts.TYPE_BYTE;
            }
        }
        return type;
    }

    public static io.polaris.dependency.org.objectweb.asm.Type getUnboxedType(io.polaris.dependency.org.objectweb.asm.Type type) {
        if (AsmConsts.TYPE_INTEGER.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.INT_TYPE;
        }
        if (AsmConsts.TYPE_BOOLEAN.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.BOOLEAN_TYPE;
        }
        if (AsmConsts.TYPE_DOUBLE.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.DOUBLE_TYPE;
        }
        if (AsmConsts.TYPE_LONG.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.LONG_TYPE;
        }
        if (AsmConsts.TYPE_CHARACTER.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.CHAR_TYPE;
        }
        if (AsmConsts.TYPE_BYTE.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.BYTE_TYPE;
        }
        if (AsmConsts.TYPE_FLOAT.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.FLOAT_TYPE;
        }
        if (AsmConsts.TYPE_SHORT.equals(type)) {
            return io.polaris.dependency.org.objectweb.asm.Type.SHORT_TYPE;
        }
        return type;
    }

    public static boolean isArray(io.polaris.dependency.org.objectweb.asm.Type type) {
        return type.getSort() == 9;
    }

    public static io.polaris.dependency.org.objectweb.asm.Type getComponentType(io.polaris.dependency.org.objectweb.asm.Type type) {
        if (!AsmTypes.isArray(type)) {
            throw new IllegalArgumentException("Type " + type + " is not an array");
        }
        return io.polaris.dependency.org.objectweb.asm.Type.getType(type.getDescriptor().substring(1));
    }

    public static boolean isPrimitive(io.polaris.dependency.org.objectweb.asm.Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static String emulateClassGetName(io.polaris.dependency.org.objectweb.asm.Type type) {
        if (AsmTypes.isArray(type)) {
            return type.getDescriptor().replace('/', '.');
        }
        return AsmTypes.getClassName(type);
    }

    public static boolean isConstructor(MethodInfo method) {
        return method.getSignature().getName().equals("<init>");
    }

    public static io.polaris.dependency.org.objectweb.asm.Type[] getTypes(Class[] classes) {
        if (classes == null) {
            return null;
        }
        io.polaris.dependency.org.objectweb.asm.Type[] types = new io.polaris.dependency.org.objectweb.asm.Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = io.polaris.dependency.org.objectweb.asm.Type.getType(classes[i]);
        }
        return types;
    }

    public static int ICONST(int value) {
        switch (value) {
            case -1: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return -1;
    }

    public static int LCONST(long value) {
        if (value == 0L) {
            return 9;
        }
        if (value == 1L) {
            return 10;
        }
        return -1;
    }

    public static int FCONST(float value) {
        if (value == 0.0f) {
            return 11;
        }
        if (value == 1.0f) {
            return 12;
        }
        if (value == 2.0f) {
            return 13;
        }
        return -1;
    }

    public static int DCONST(double value) {
        if (value == 0.0) {
            return 14;
        }
        if (value == 1.0) {
            return 15;
        }
        return -1;
    }

    public static int NEWARRAY(io.polaris.dependency.org.objectweb.asm.Type type) {
        switch (type.getSort()) {
            case 3: {
                return 8;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 4: {
                return 9;
            }
            case 1: {
                return 4;
            }
        }
        return -1;
    }

    public static String escapeType(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '$': {
                    sb.append("$24");
                    continue block9;
                }
                case '.': {
                    sb.append("$2E");
                    continue block9;
                }
                case '[': {
                    sb.append("$5B");
                    continue block9;
                }
                case ';': {
                    sb.append("$3B");
                    continue block9;
                }
                case '(': {
                    sb.append("$28");
                    continue block9;
                }
                case ')': {
                    sb.append("$29");
                    continue block9;
                }
                case '/': {
                    sb.append("$2F");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static {
        transforms.put("void", "V");
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
        Maps.reverse(transforms, rtransforms);
    }
}

