/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.clock;

import io.polaris.core.concurrent.Schedules;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimeMillisClock {
    private final int period;
    private volatile long currentTimeMillis;

    private TimeMillisClock(int period) {
        this.period = period;
        this.currentTimeMillis = System.currentTimeMillis();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "Clock-" + period));
        executor.scheduleAtFixedRate(() -> {
            this.currentTimeMillis = System.currentTimeMillis();
        }, period, period, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Schedules.shutdown(executor)));
    }

    public static TimeMillisClock newClock(int period) {
        return new TimeMillisClock(period);
    }

    public static long currentTimeMillis() {
        return Holder.instance.currentTimeMillis;
    }

    static class Holder {
        static TimeMillisClock instance = new TimeMillisClock(1);

        Holder() {
        }
    }
}

