/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.codec;

import io.polaris.core.codec.Base16Encoder;
import io.polaris.core.codec.CodecException;
import io.polaris.core.codec.CodecStrings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base16 {
    private static final Base16Encoder encoder = new Base16Encoder();

    public static String encodeToString(byte[] data) {
        return Base16.encodeToString(data, 0, data.length);
    }

    public static String encodeToString(byte[] data, int off, int length) {
        byte[] encoded = Base16.encode(data, off, length);
        return CodecStrings.fromByteArray(encoded);
    }

    public static byte[] encode(byte[] data) {
        return Base16.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.encode(data, off, length, bOut);
        }
        catch (Exception e) {
            throw new CodecException("exception encoding Base16 string: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return encoder.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return encoder.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, 0, data.length, bOut);
        }
        catch (Exception e) {
            throw new CodecException("exception decoding Base16 data: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, bOut);
        }
        catch (Exception e) {
            throw new CodecException("exception decoding Base16 string: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return encoder.decode(data, out);
    }

    public static byte[] decodeStrict(String str) {
        try {
            return encoder.decodeStrict(str, 0, str.length());
        }
        catch (Exception e) {
            throw new CodecException("exception decoding Base16 string: " + e.getMessage(), e);
        }
    }

    public static byte[] decodeStrict(String str, int off, int len) {
        try {
            return encoder.decodeStrict(str, off, len);
        }
        catch (Exception e) {
            throw new CodecException("exception decoding Base16 string: " + e.getMessage(), e);
        }
    }
}

