/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.codec;

import io.polaris.core.codec.CodecStrings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Codec {
    public static final byte PADDING = 61;
    private static final byte[] BASE64_ENC_TABLE = CodecStrings.toByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    private static final byte[] BASE64_DEC_TABLE = Codec.toDecodingTable(BASE64_ENC_TABLE);
    private static final byte[] BASE32_ENC_TABLE = CodecStrings.toByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    private static final byte[] BASE32_DEC_TABLE = Codec.toDecodingTable(BASE32_ENC_TABLE);
    private static final byte[] BASE32_CROCKFORD_ENC_TABLE = CodecStrings.toByteArray("0123456789ABCDEFGHJKMNPQRSTVWXYZ");
    private static final byte[] BASE32_CROCKFORD_DEC_TABLE = Codec.toDecodingTable(BASE32_CROCKFORD_ENC_TABLE);
    private static final byte[] BASE16_ENC_TABLE = CodecStrings.toByteArray("0123456789ABCDEF");
    private static final byte[] BASE16_DEC_TABLE = Codec.toDecodingTable(BASE16_ENC_TABLE);

    public static byte[] encodeBase64(byte[] data) {
        return Codec.innerEncode(data, BASE64_ENC_TABLE, 6);
    }

    public static char[] encodeBase64AsCharArray(byte[] data) {
        return Codec.innerEncodeAsCharArray(data, BASE64_ENC_TABLE, 6);
    }

    public static String encodeBase64AsString(byte[] data) {
        return new String(Codec.innerEncode(data, BASE64_ENC_TABLE, 6), StandardCharsets.ISO_8859_1);
    }

    public static byte[] decodeBase64(byte[] data) {
        return Codec.innerDecode(data, BASE64_DEC_TABLE, 6, (byte)61);
    }

    public static byte[] decodeBase64(char[] data) {
        return Codec.innerDecode(data, BASE64_DEC_TABLE, 6, (byte)61);
    }

    public static byte[] decodeBase64(String data) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE64_DEC_TABLE, 6, (byte)61);
    }

    public static byte[] decodeBase64(byte[] data, byte padding) {
        return Codec.innerDecode(data, BASE64_DEC_TABLE, 6, padding);
    }

    public static byte[] decodeBase64(char[] data, byte padding) {
        return Codec.innerDecode(data, BASE64_DEC_TABLE, 6, padding);
    }

    public static byte[] decodeBase64(String data, byte padding) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE64_DEC_TABLE, 6, padding);
    }

    public static byte[] encodeBase32(byte[] data) {
        return Codec.innerEncode(data, BASE32_ENC_TABLE, 5);
    }

    public static char[] encodeBase32AsCharArray(byte[] data) {
        return Codec.innerEncodeAsCharArray(data, BASE32_ENC_TABLE, 5);
    }

    public static String encodeBase32AsString(byte[] data) {
        return new String(Codec.innerEncode(data, BASE32_ENC_TABLE, 5), StandardCharsets.ISO_8859_1);
    }

    public static byte[] decodeBase32(byte[] data) {
        return Codec.innerDecode(data, BASE32_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeBase32(char[] data) {
        return Codec.innerDecode(data, BASE32_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeBase32(String data) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE32_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeBase32(byte[] data, byte padding) {
        return Codec.innerDecode(data, BASE32_DEC_TABLE, 5, padding);
    }

    public static byte[] decodeBase32(char[] data, byte padding) {
        return Codec.innerDecode(data, BASE32_DEC_TABLE, 5, padding);
    }

    public static byte[] decodeBase32(String data, byte padding) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE32_DEC_TABLE, 5, padding);
    }

    public static byte[] encodeCrockfordBase32(byte[] data) {
        return Codec.encode(data, BASE32_CROCKFORD_ENC_TABLE, 5);
    }

    public static char[] encodeCrockfordBase32AsCharArray(byte[] data) {
        return Codec.innerEncodeAsCharArray(data, BASE32_CROCKFORD_ENC_TABLE, 5);
    }

    public static String encodeCrockfordBase32AsString(byte[] data) {
        return new String(Codec.innerEncode(data, BASE32_CROCKFORD_ENC_TABLE, 5), StandardCharsets.ISO_8859_1);
    }

    public static byte[] decodeCrockfordBase32(byte[] data) {
        return Codec.innerDecode(data, BASE32_CROCKFORD_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeCrockfordBase32(char[] data) {
        return Codec.innerDecode(data, BASE32_CROCKFORD_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeCrockfordBase32(String data) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE32_CROCKFORD_DEC_TABLE, 5, (byte)61);
    }

    public static byte[] decodeCrockfordBase32(byte[] data, byte padding) {
        return Codec.innerDecode(data, BASE32_CROCKFORD_DEC_TABLE, 5, padding);
    }

    public static byte[] decodeCrockfordBase32(char[] data, byte padding) {
        return Codec.innerDecode(data, BASE32_CROCKFORD_DEC_TABLE, 5, padding);
    }

    public static byte[] decodeCrockfordBase32(String data, byte padding) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE32_CROCKFORD_DEC_TABLE, 5, padding);
    }

    public static byte[] encodeBase16(byte[] data) {
        return Codec.innerEncode(data, BASE16_ENC_TABLE, 4);
    }

    public static char[] encodeBase16AsCharArray(byte[] data) {
        return Codec.innerEncodeAsCharArray(data, BASE16_ENC_TABLE, 4);
    }

    public static String encodeBase16AsString(byte[] data) {
        return new String(Codec.innerEncode(data, BASE16_ENC_TABLE, 4), StandardCharsets.ISO_8859_1);
    }

    public static byte[] decodeBase16(byte[] data) {
        return Codec.innerDecode(data, BASE16_DEC_TABLE, 4, (byte)0);
    }

    public static byte[] decodeBase16(char[] data) {
        return Codec.innerDecode(data, BASE16_DEC_TABLE, 4, (byte)0);
    }

    public static byte[] decodeBase16(String data) {
        return Codec.innerDecode(data.getBytes(StandardCharsets.ISO_8859_1), BASE16_DEC_TABLE, 4, (byte)0);
    }

    public static byte[] decode(byte[] data, byte[] encodingTable, int bits) {
        return Codec.decode(data, encodingTable, bits, (byte)61);
    }

    public static byte[] decode(byte[] data, byte[] encodingTable, int bits, byte padding) {
        if (bits < 1 || bits > 8) {
            throw new IllegalArgumentException("bits must be in [1,8]");
        }
        if (1 << bits != encodingTable.length) {
            throw new IllegalArgumentException("encodingTable's length must be 2^bits");
        }
        return Codec.innerDecode(data, Codec.toDecodingTable(encodingTable), bits, padding);
    }

    public static byte[] decode(char[] data, byte[] encodingTable, int bits) {
        return Codec.decode(data, encodingTable, bits, (byte)61);
    }

    public static byte[] decode(char[] data, byte[] encodingTable, int bits, byte padding) {
        if (bits < 1 || bits > 8) {
            throw new IllegalArgumentException("bits must be in [1,8]");
        }
        if (1 << bits != encodingTable.length) {
            throw new IllegalArgumentException("encodingTable's length must be 2^bits");
        }
        return Codec.innerDecode(data, Codec.toDecodingTable(encodingTable), bits, padding);
    }

    public static byte[] encode(byte[] data, byte[] encodingTable, int bits) {
        if (bits < 1 || bits > 8) {
            throw new IllegalArgumentException("bits must be in [1,8]");
        }
        if (1 << bits != encodingTable.length) {
            throw new IllegalArgumentException("encodingTable's length must be 2^bits");
        }
        return Codec.innerEncode(data, encodingTable, bits);
    }

    public static char[] encodeAsCharArray(byte[] data, byte[] encodingTable, int bits) {
        if (bits < 1 || bits > 8) {
            throw new IllegalArgumentException("bits must be in [1,8]");
        }
        if (1 << bits != encodingTable.length) {
            throw new IllegalArgumentException("encodingTable's length must be 2^bits");
        }
        return Codec.innerEncodeAsCharArray(data, encodingTable, bits);
    }

    private static byte[] innerDecode(byte[] data, byte[] decodingTable, int bits, byte padding) {
        if (data.length == 0) {
            return new byte[0];
        }
        int end = data.length - 1;
        if (padding != 0) {
            for (int i = end; i >= 0; --i) {
                if (data[i] == padding) continue;
                end = i;
                break;
            }
            if (end == 0) {
                return new byte[0];
            }
        }
        byte[] rs = new byte[data.length * bits / 8];
        int decIdx = 0;
        int curBits = 0;
        byte cur = 0;
        for (int i = 0; i < data.length; ++i) {
            byte datum = data[i];
            int b = decodingTable[datum];
            if (b == -1) {
                throw new IllegalArgumentException("Invalid data: " + i + " - " + datum);
            }
            b &= 0xFF;
            int extraBits = 8 - curBits;
            if (bits < extraBits) {
                cur = (byte)(cur << bits | b);
                curBits += bits;
                continue;
            }
            cur = (byte)(cur << extraBits | b >>> bits - extraBits);
            rs[decIdx++] = cur;
            curBits = bits - extraBits;
            cur = (byte)(b & (1 << curBits) - 1);
        }
        if (decIdx < rs.length - 1 && curBits > 0) {
            rs[decIdx++] = cur;
        }
        return rs;
    }

    private static byte[] innerDecode(char[] data, byte[] decodingTable, int bits, byte padding) {
        if (data.length == 0) {
            return new byte[0];
        }
        int end = data.length - 1;
        if (padding != 0) {
            for (int i = end; i >= 0; --i) {
                if ((byte)data[i] == padding) continue;
                end = i;
                break;
            }
            if (end == 0) {
                return new byte[0];
            }
        }
        byte[] rs = new byte[(end + 1) * bits / 8];
        int decIdx = 0;
        int curBits = 0;
        byte cur = 0;
        for (int i = 0; i <= end; ++i) {
            char datum = data[i];
            int b = decodingTable[datum];
            if (b == -1) {
                throw new IllegalArgumentException("Invalid data: " + i + " - " + datum);
            }
            b &= 0xFF;
            int extraBits = 8 - curBits;
            if (bits < extraBits) {
                cur = (byte)(cur << bits | b);
                curBits += bits;
                continue;
            }
            cur = (byte)(cur << extraBits | b >>> bits - extraBits);
            rs[decIdx++] = cur;
            curBits = bits - extraBits;
            cur = (byte)(b & (1 << curBits) - 1);
        }
        if (decIdx < rs.length - 1 && curBits > 0) {
            rs[decIdx++] = cur;
        }
        return rs;
    }

    private static byte[] innerEncode(byte[] data, byte[] encodingTable, int bits) {
        if (data.length == 0) {
            return new byte[0];
        }
        byte[] rs = new byte[data.length * 8 % bits > 0 ? data.length * 8 / bits + 1 : data.length * 8 / bits];
        int encIdx = 0;
        int remainBits = 0;
        int remain = 0;
        for (int n : data) {
            n &= 0xFF;
            int datumBits = 8;
            if (remainBits > 0) {
                int extraBits = bits - remainBits;
                int index = remain << extraBits | n >>> datumBits - extraBits;
                rs[encIdx++] = encodingTable[index];
                n &= (byte)((1 << (datumBits -= extraBits)) - 1);
            }
            while (datumBits >= bits) {
                int index = n >>> datumBits - bits;
                rs[encIdx++] = encodingTable[index];
                n &= (byte)((1 << (datumBits -= bits)) - 1);
            }
            remainBits = datumBits;
            remain = remainBits == 0 ? 0 : n & (1 << remainBits) - 1;
        }
        if (remainBits > 0) {
            int extraBits = bits - remainBits;
            int index = remain << extraBits;
            rs[encIdx++] = encodingTable[index];
        }
        return rs;
    }

    private static char[] innerEncodeAsCharArray(byte[] data, byte[] encodingTable, int bits) {
        if (data.length == 0) {
            return new char[0];
        }
        char[] rs = new char[data.length * 8 % bits > 0 ? data.length * 8 / bits + 1 : data.length * 8 / bits];
        int encIdx = 0;
        int remainBits = 0;
        int remain = 0;
        for (int n : data) {
            n &= 0xFF;
            int datumBits = 8;
            if (remainBits > 0) {
                int extraBits = bits - remainBits;
                int index = remain << extraBits | n >>> datumBits - extraBits;
                rs[encIdx++] = (char)encodingTable[index];
                n &= (byte)((1 << (datumBits -= extraBits)) - 1);
            }
            while (datumBits >= bits) {
                int index = n >>> datumBits - bits;
                rs[encIdx++] = (char)encodingTable[index];
                n &= (byte)((1 << (datumBits -= bits)) - 1);
            }
            remainBits = datumBits;
            remain = remainBits == 0 ? 0 : n & (1 << remainBits) - 1;
        }
        if (remainBits > 0) {
            int extraBits = bits - remainBits;
            int index = remain << extraBits;
            rs[encIdx++] = (char)encodingTable[index];
        }
        return rs;
    }

    private static byte[] toDecodingTable(byte[] encodingTable) {
        byte[] decodingTable = new byte[256];
        Arrays.fill(decodingTable, (byte)-1);
        for (int i = 0; i < encodingTable.length; ++i) {
            decodingTable[encodingTable[i]] = (byte)i;
        }
        return decodingTable;
    }
}

