/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.collection;

import io.polaris.core.collection.Iterators;
import io.polaris.core.collection.Lists;
import io.polaris.core.collection.Sets;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Iterables {
    public static <E> Iterator<E> iterator(Enumeration<E> enumeration) {
        return Iterators.iterator(enumeration);
    }

    public static <E> Enumeration<E> enumeration(Iterable<E> iterable) {
        return Iterators.enumeration(iterable);
    }

    public static <E> Enumeration<E> enumeration(Iterator<E> iterator) {
        return Iterators.enumeration(iterator);
    }

    public static <E, K> Map<K, E> asMap(Iterable<E> iterable, Function<E, K> keyConverter) {
        return Iterables.asMap(iterable, HashMap::new, keyConverter, Function.identity(), false);
    }

    public static <E, K> Map<K, E> asMap(Iterable<E> iterable, Supplier<Map<K, E>> supplier, Function<E, K> keyConverter) {
        return Iterables.asMap(iterable, supplier, keyConverter, Function.identity(), false);
    }

    public static <E, K, V> Map<K, V> asMap(Iterable<E> iterable, Supplier<Map<K, V>> supplier, Function<E, K> keyConverter, Function<E, V> valueConverter) {
        return Iterables.asMap(iterable, supplier, keyConverter, valueConverter, false);
    }

    public static <E, K, V> Map<K, V> asMap(Iterable<E> iterable, Function<E, K> keyConverter, Function<E, V> valueConverter) {
        return Iterables.asMap(iterable, HashMap::new, keyConverter, valueConverter, false);
    }

    public static <E, K, V> Map<K, V> asMap(Iterable<E> iterable, Function<E, K> keyConverter, Function<E, V> valueConverter, boolean replaceIfPresent) {
        return Iterables.asMap(iterable, HashMap::new, keyConverter, valueConverter, replaceIfPresent);
    }

    public static <E, K, V> Map<K, V> asMap(Iterable<E> iterable, Supplier<Map<K, V>> supplier, Function<E, K> keyConverter, Function<E, V> valueConverter, boolean replaceIfPresent) {
        Map<K, V> map = supplier.get();
        if (replaceIfPresent) {
            for (E e : iterable) {
                map.put(keyConverter.apply(e), valueConverter.apply(e));
            }
        } else {
            for (E e : iterable) {
                map.putIfAbsent(keyConverter.apply(e), valueConverter.apply(e));
            }
        }
        return map;
    }

    public static <C extends Collection<O>, E, O> C asCollection(Supplier<C> supplier, Function<E, O> converter, Enumeration<E> enumeration) {
        Collection c = (Collection)supplier.get();
        while (enumeration.hasMoreElements()) {
            c.add(converter.apply(enumeration.nextElement()));
        }
        return (C)c;
    }

    public static <C extends Collection<E>, E> C asCollection(Supplier<C> supplier, Enumeration<E> enumeration) {
        Collection c = (Collection)supplier.get();
        while (enumeration.hasMoreElements()) {
            c.add(enumeration.nextElement());
        }
        return (C)c;
    }

    public static <C extends Collection<O>, E, O> C asCollection(Supplier<C> supplier, Function<E, O> converter, E ... iterable) {
        Collection c = (Collection)supplier.get();
        for (E e : iterable) {
            c.add(converter.apply(e));
        }
        return (C)c;
    }

    public static <C extends Collection<E>, E> C asCollection(Supplier<C> supplier, E ... iterable) {
        Collection c = (Collection)supplier.get();
        Collections.addAll(c, iterable);
        return (C)c;
    }

    public static <C extends Collection<O>, E, O> C asCollection(Supplier<C> supplier, Function<E, O> converter, Iterable<E> iterable) {
        Collection c = (Collection)supplier.get();
        for (E e : iterable) {
            c.add(converter.apply(e));
        }
        return (C)c;
    }

    public static <C extends Collection<E>, E> C asCollection(Supplier<C> supplier, Iterable<E> iterable) {
        Collection c = (Collection)supplier.get();
        for (E e : iterable) {
            c.add(e);
        }
        return (C)c;
    }

    public static <C extends Collection<O>, E, O> C asCollection(Supplier<C> supplier, Function<E, O> converter, Iterator<E> iterator) {
        Collection c = (Collection)supplier.get();
        while (iterator.hasNext()) {
            c.add(converter.apply(iterator.next()));
        }
        return (C)c;
    }

    public static <C extends Collection<E>, E> C asCollection(Supplier<C> supplier, Iterator<E> iterator) {
        Collection c = (Collection)supplier.get();
        while (iterator.hasNext()) {
            c.add(iterator.next());
        }
        return (C)c;
    }

    public static <E> List<E> asList(Enumeration<E> enumeration) {
        return Lists.asList(enumeration);
    }

    public static <E> Set<E> asSet(Enumeration<E> enumeration) {
        return Sets.asSet(enumeration);
    }

    @SafeVarargs
    public static <E> List<E> asList(E ... iterable) {
        return Lists.asList(iterable);
    }

    @SafeVarargs
    public static <E> Set<E> asSet(E ... iterable) {
        return Sets.asSet(iterable);
    }

    public static <E> List<E> asList(Iterable<E> iterable) {
        return Lists.asList(iterable);
    }

    public static <E> Set<E> asSet(Iterable<E> iterable) {
        return Sets.asSet(iterable);
    }

    public static <E> List<E> asList(Iterator<E> iterator) {
        return Lists.asList(iterator);
    }

    public static <E> Set<E> asSet(Iterator<E> iterator) {
        return Sets.asSet(iterator);
    }

    public static <E> E[] copyOf(E[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static <S, T> Iterator<T> convert(Iterator<S> iterator, Function<S, T> converter) {
        return Iterators.convert(iterator, converter);
    }

    public static <S, T> T[] convert(S[] array, T[] target, Function<S, T> converter) {
        if (target.length < array.length) {
            target = target.getClass() == Object[].class ? new Object[array.length] : (Object[])Array.newInstance(target.getClass().getComponentType(), array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            target[i] = converter.apply(array[i]);
        }
        return target;
    }

    public static <S, T> boolean isMatchAll(S[] array1, T[] array2, BiFunction<S, T, Boolean> matcher) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Boolean matched = matcher.apply(array1[i], array2[i]);
            if (matched.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isEmpty(Iterable<E> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return iterable.iterator().hasNext();
    }

    public static <E> boolean isEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <E> boolean isEmpty(E[] array) {
        return array == null || array.length == 0;
    }

    public static <E> boolean isNotEmpty(Iterable<E> iterable) {
        return !Iterables.isEmpty(iterable);
    }

    public static <E> boolean isNotEmpty(Collection<E> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <E> boolean isNotEmpty(E[] array) {
        return array != null && array.length > 0;
    }

    public static <E> boolean hasNull(E[] array) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean hasNull(Iterable<E> array) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean isMatchAny(E[] array, Function<E, Boolean> matcher) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (!matcher.apply(e).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean isMatchAny(Iterable<E> array, Function<E, Boolean> matcher) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (!matcher.apply(e).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean isMatchAll(E[] array, Function<E, Boolean> matcher) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (matcher.apply(e).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isMatchAll(Iterable<E> array, Function<E, Boolean> matcher) {
        if (array == null) {
            return false;
        }
        for (E e : array) {
            if (matcher.apply(e).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static String toArrayString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj.getClass().isArray()) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return collection != null && !collection.isEmpty() && collection.contains(value);
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<? super T> predicate) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (coll1 == null || coll1.isEmpty() || coll2 == null || coll2.isEmpty()) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (coll1 == null || coll1.isEmpty()) {
            return coll2 == null || coll2.isEmpty();
        }
        if (coll2 == null || coll2.isEmpty()) {
            return true;
        }
        if (coll1 instanceof Set) {
            return coll1.containsAll(coll2);
        }
        Iterator<?> it = coll1.iterator();
        HashSet elementsAlreadySeen = new HashSet(coll1.size(), 1.0f);
        for (Object nextElement : coll2) {
            if (elementsAlreadySeen.contains(nextElement)) continue;
            boolean foundCurrentElement = false;
            while (it.hasNext()) {
                Object p = it.next();
                elementsAlreadySeen.add(p);
                if (!Objects.equals(nextElement, p)) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }

    public static <T> T firstNonNull(Collection<T> collection) {
        return (T)Iterables.firstMatch(collection, Objects::nonNull);
    }

    public static <T> T firstNonNull(Iterable<T> collection) {
        return (T)Iterables.firstMatch(collection, Objects::nonNull);
    }

    public static <T> T firstMatch(Collection<T> collection, Predicate<T> matcher) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        for (T next : collection) {
            if (!matcher.test(next)) continue;
            return next;
        }
        return null;
    }

    public static <T> T firstMatch(Iterable<T> collection, Predicate<T> matcher) {
        if (collection == null) {
            return null;
        }
        for (T next : collection) {
            if (!matcher.test(next)) continue;
            return next;
        }
        return null;
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        return collection.stream().anyMatch(predicate);
    }

    public static <T> boolean allMatch(Collection<T> collection, Predicate<T> predicate) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        return collection.stream().allMatch(predicate);
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        return Iterators.get(collection.iterator(), index);
    }

    public static <T> List<T> getAll(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                if (index >= size || index < 0) {
                    result.add(null);
                    continue;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                if (index >= size || index < 0) {
                    result.add(null);
                    continue;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            return list.isEmpty() ? null : (T)list.get(0);
        }
        return Iterators.getNext(iterable.iterator());
    }
}

