/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.collection;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.collection.Iterables;
import io.polaris.core.collection.PrimitiveArrays;
import io.polaris.core.collection.comparator.Comparators;
import io.polaris.core.consts.StdConsts;
import io.polaris.core.converter.Converters;
import io.polaris.core.lang.Objs;
import io.polaris.core.random.Randoms;
import io.polaris.core.string.Strings;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ObjectArrays
extends PrimitiveArrays {
    public static final Object[] EMPTY = StdConsts.EMPTY_ARRAY;

    public static List<Object> toList(Object array) {
        ArrayList<Object> c = new ArrayList<Object>();
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object next = Array.get(array, i);
            c.add(next);
        }
        return c;
    }

    public static Set<Object> toSet(Object array) {
        HashSet<Object> c = new HashSet<Object>();
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object next = Array.get(array, i);
            c.add(next);
        }
        return c;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ObjectArrays.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ObjectArrays.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ObjectArrays.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (array != null) {
            for (T element : array) {
                if (!Objs.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ObjectArrays.firstNonNull(array);
    }

    public static <T> T firstNonNull(T ... array) {
        return (T)ObjectArrays.firstMatch(Objs::isNotNull, array);
    }

    public static <T> T firstMatch(Predicate<T> matcher, T ... array) {
        int index = ObjectArrays.matchIndex(matcher, array);
        if (index < 0) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Predicate<T> matcher, T ... array) {
        return ObjectArrays.matchIndex(matcher, 0, array);
    }

    public static <T> int matchIndex(Predicate<T> matcher, int beginIndexInclude, T ... array) {
        if (ObjectArrays.isNotEmpty(array)) {
            for (int i = beginIndexInclude; i < array.length; ++i) {
                if (!matcher.test(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ObjectArrays.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ObjectArrays.isEmpty(buffer)) {
            return newElements;
        }
        return ObjectArrays.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <T> Object append(Object array, T ... newElements) {
        if (ObjectArrays.isEmpty(array)) {
            return newElements;
        }
        return ObjectArrays.insert(array, ObjectArrays.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        if (ObjectArrays.isEmpty(buffer)) {
            T[] values = ObjectArrays.newArray(value.getClass(), 1);
            values[0] = value;
            return ObjectArrays.append(buffer, values);
        }
        return ObjectArrays.append(buffer, value);
    }

    public static Object setOrAppend(Object array, int index, Object value) {
        if (index < ObjectArrays.length(array)) {
            Array.set(array, index, value);
            return array;
        }
        return ObjectArrays.append(array, value);
    }

    public static <T> T[] replace(T[] buffer, int index, T ... values) {
        if (ObjectArrays.isEmpty(values)) {
            return buffer;
        }
        if (ObjectArrays.isEmpty(buffer)) {
            return values;
        }
        if (index < 0) {
            return ObjectArrays.insert(buffer, 0, values);
        }
        if (index >= buffer.length) {
            return ObjectArrays.append(buffer, values);
        }
        if (buffer.length >= values.length + index) {
            System.arraycopy(values, 0, buffer, index, values.length);
            return buffer;
        }
        int newArrayLength = index + values.length;
        T[] result = ObjectArrays.newArray(buffer.getClass().getComponentType(), newArrayLength);
        System.arraycopy(buffer, 0, result, 0, index);
        System.arraycopy(values, 0, result, index, values.length);
        return result;
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ObjectArrays.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ObjectArrays.isEmpty(newElements)) {
            return array;
        }
        if (ObjectArrays.isEmpty(array)) {
            return newElements;
        }
        int len = ObjectArrays.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        Class<?> originComponentType = array.getClass().getComponentType();
        Object newEleArr = newElements;
        if (originComponentType.isPrimitive()) {
            newEleArr = Converters.convert(array.getClass(), newElements);
        }
        Object result = Array.newInstance(originComponentType, Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newEleArr, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ObjectArrays.newArray(componentType, newSize);
        if (newSize > 0 && ObjectArrays.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ObjectArrays.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ObjectArrays.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ObjectArrays.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (!ObjectArrays.isNotEmpty(array)) continue;
            length += array.length;
        }
        T[] result = ObjectArrays.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (!ObjectArrays.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ObjectArrays.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array, Function<T, T> editor) {
        if (null == editor) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.apply(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = ObjectArrays.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array, Predicate<T> filter) {
        if (null == array || null == filter) {
            return array;
        }
        return ObjectArrays.edit(array, t -> filter.test(t) ? t : null);
    }

    public static <T> T[] removeNull(T[] array) {
        return ObjectArrays.edit(array, t -> t);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ObjectArrays.filter(array, Strings::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ObjectArrays.filter(array, Strings::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array) {
        return ObjectArrays.edit(array, t -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ObjectArrays.isEmpty(keys) || ObjectArrays.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap map = isOrder ? new LinkedHashMap(size) : new HashMap(size);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ObjectArrays.zip(keys, values, false);
    }

    public static <T> int indexOf(T[] array, Object value, int beginIndexInclude) {
        return ObjectArrays.matchIndex((T obj) -> Objs.equals(value, obj), beginIndexInclude, array);
    }

    public static <T> int indexOf(T[] array, Object value) {
        return ObjectArrays.matchIndex((T obj) -> Objs.equals(value, obj), array);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!Strings.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        if (ObjectArrays.isEmpty(array)) {
            return -1;
        }
        return ObjectArrays.lastIndexOf(array, value, array.length - 1);
    }

    public static <T> int lastIndexOf(T[] array, Object value, int endInclude) {
        if (ObjectArrays.isNotEmpty(array)) {
            for (int i = endInclude; i >= 0; --i) {
                if (!Objs.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ObjectArrays.indexOf(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ObjectArrays.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        for (T value : values) {
            if (ObjectArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ObjectArrays.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ObjectArrays.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ObjectArrays.wrap((long[])obj);
                    }
                    case "int": {
                        return ObjectArrays.wrap((int[])obj);
                    }
                    case "short": {
                        return ObjectArrays.wrap((short[])obj);
                    }
                    case "char": {
                        return ObjectArrays.wrap((char[])obj);
                    }
                    case "byte": {
                        return ObjectArrays.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ObjectArrays.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ObjectArrays.wrap((float[])obj);
                    }
                    case "double": {
                        return ObjectArrays.wrap((double[])obj);
                    }
                }
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(Strings.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static <T> T get(Object array, int index) {
        if (null == array) {
            return null;
        }
        if (index < 0) {
            index += Array.getLength(array);
        }
        try {
            return (T)Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        if (null == array) {
            return null;
        }
        if (null == indexes) {
            return ObjectArrays.newArray(array.getClass().getComponentType(), 0);
        }
        T[] result = ObjectArrays.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = ObjectArrays.get(array, indexes[i]);
        }
        return result;
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        int length = ObjectArrays.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ObjectArrays.newArray(array.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return ObjectArrays.newArray(array.getClass().getComponentType(), 0);
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static Object[] sub(Object array, int start, int end) {
        return ObjectArrays.sub(array, start, end, 1);
    }

    public static Object[] sub(Object array, int start, int end, int step) {
        int length = ObjectArrays.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new Object[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new Object[0];
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ObjectArrays.get(array, i));
        }
        return list.toArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ObjectArrays.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ObjectArrays.join(array, conjunction, "", "");
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(delimiter);
        ObjectArrays.joinAll(joiner, o -> prefix + o + suffix, array);
        return joiner.toString();
    }

    private static void joinAll(StringJoiner joiner, Function<Object, String> converter, Object array) {
        if (array == null) {
            joiner.add(converter.apply(null));
        } else if (array instanceof Iterable) {
            ((Iterable)array).forEach(o -> ObjectArrays.joinAll(joiner, converter, o));
        } else if (array instanceof Iterator) {
            ((Iterator)array).forEachRemaining(o -> ObjectArrays.joinAll(joiner, converter, o));
        } else if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ObjectArrays.joinAll(joiner, converter, Array.get(array, i));
            }
        } else {
            joiner.add(converter.apply(array));
        }
    }

    public static <T> String join(T[] array, CharSequence conjunction, Function<T, T> editor) {
        StringJoiner joiner = new StringJoiner(conjunction);
        ObjectArrays.joinAll(joiner, o -> String.valueOf(editor.apply(o)), array);
        return joiner.toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(conjunction);
        ObjectArrays.joinAll(joiner, String::valueOf, array);
        return joiner.toString();
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (bytebuffer.hasArray()) {
            return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
        }
        int oldPosition = bytebuffer.position();
        bytebuffer.position(0);
        int size = bytebuffer.limit();
        byte[] buffers = new byte[size];
        bytebuffer.get(buffers);
        bytebuffer.position(oldPosition);
        return buffers;
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        List<T> list = Iterables.asList(iterator);
        return ObjectArrays.toArray(list, componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        List<T> collection = iterable instanceof Collection ? (List<T>)iterable : Iterables.asList(iterable.iterator());
        return ObjectArrays.toArray(collection, componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(ObjectArrays.newArray(componentType, 0));
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = Array.getLength(array);
        if (index < 0 || index >= length) {
            return array;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return (Object[])result;
    }

    public static <T> T[] removeElement(T[] array, T element) throws IllegalArgumentException {
        return ObjectArrays.remove(array, ObjectArrays.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ObjectArrays.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ObjectArrays.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ObjectArrays.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        if (ObjectArrays.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : numberArray) {
            if (Comparators.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ObjectArrays.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ObjectArrays.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (Comparators.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] shuffle(T[] array) {
        return ObjectArrays.shuffle(array, (Random)Randoms.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ObjectArrays.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        Object tmp = ObjectArrays.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static int emptyCount(Object ... args) {
        int count = 0;
        if (ObjectArrays.isNotEmpty(args)) {
            for (Object element : args) {
                if (!Objs.isEmpty(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean hasEmpty(Object ... args) {
        if (args != null) {
            for (Object element : args) {
                if (!Objs.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... args) {
        if (args != null) {
            for (Object obj : args) {
                if (!Objs.isEmpty(obj)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return !ObjectArrays.hasEmpty(args);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return !ObjectArrays.hasNull(array);
    }

    public static <T> T[] distinct(T[] array) {
        if (ObjectArrays.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ObjectArrays.toArray(set, ObjectArrays.getComponentType(array));
    }

    public static <T, K> T[] distinct(T[] array, Function<T, K> uniqueGenerator, boolean override) {
        if (ObjectArrays.isEmpty(array)) {
            return array;
        }
        HashMap<K, T> map = new HashMap<K, T>();
        if (override) {
            for (T t : array) {
                map.put(uniqueGenerator.apply(t), t);
            }
        } else {
            for (T t : array) {
                map.putIfAbsent(uniqueGenerator.apply(t), t);
            }
        }
        return ObjectArrays.toArray(map.values(), ObjectArrays.getComponentType(array));
    }

    public static <T, R> R[] map(T[] array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        T[] result = ObjectArrays.newArray(targetComponentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = func.apply(array[i]);
        }
        return result;
    }

    public static <T, R> R[] map(Object array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        int length = ObjectArrays.length(array);
        T[] result = ObjectArrays.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ObjectArrays.get(array, i));
        }
        return result;
    }

    public static <T, R> List<R> map(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapToSet(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toSet());
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ObjectArrays.hasNull(array1, array2)) {
            return false;
        }
        Assertions.assertTrue(ObjectArrays.isArray(array1), "First is not a Array !");
        Assertions.assertTrue(ObjectArrays.isArray(array2), "Second is not a Array !");
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> boolean isSub(T[] array, T[] subArray) {
        return ObjectArrays.indexOfSub(array, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array, T[] subArray) {
        return ObjectArrays.indexOfSub(array, 0, subArray);
    }

    public static <T> int indexOfSub(T[] array, int beginInclude, T[] subArray) {
        if (ObjectArrays.isEmpty(array) || ObjectArrays.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ObjectArrays.indexOf(array, subArray[0], beginInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (Objs.equals(array[i + firstIndex], subArray[i])) continue;
            return ObjectArrays.indexOfSub(array, firstIndex + 1, subArray);
        }
        return firstIndex;
    }

    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        if (ObjectArrays.isEmpty(array) || ObjectArrays.isEmpty(subArray)) {
            return -1;
        }
        return ObjectArrays.lastIndexOfSub(array, array.length - 1, subArray);
    }

    public static <T> int lastIndexOfSub(T[] array, int endInclude, T[] subArray) {
        if (ObjectArrays.isEmpty(array) || ObjectArrays.isEmpty(subArray) || subArray.length > array.length || endInclude < 0) {
            return -1;
        }
        int firstIndex = ObjectArrays.lastIndexOf(array, subArray[0]);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (Objs.equals(array[i + firstIndex], subArray[i])) continue;
            return ObjectArrays.lastIndexOfSub(array, firstIndex - 1, subArray);
        }
        return firstIndex;
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (array == null || comparator == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ObjectArrays.isSortedAsc(array);
    }

    public static <T extends Comparable<? super T>> boolean isSortedAsc(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDesc(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }
}

