/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.collection.comparator;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.collection.ObjectArrays;
import java.util.Comparator;

public class IndexedComparator<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final T[] array;

    public IndexedComparator(T ... objs) {
        this(false, objs);
    }

    public IndexedComparator(boolean atEndIfMiss, T ... objs) {
        Assertions.assertNotNull(objs, "'objs' array must not be null");
        this.atEndIfMiss = atEndIfMiss;
        this.array = objs;
    }

    @Override
    public int compare(T o1, T o2) {
        int index2;
        int index1 = this.getOrder(o1);
        if (index1 == (index2 = this.getOrder(o2))) {
            if (index1 < 0 || index1 == this.array.length) {
                return 1;
            }
            return 0;
        }
        return Integer.compare(index1, index2);
    }

    private int getOrder(T object) {
        int order = ObjectArrays.indexOf(this.array, object);
        if (order < 0) {
            order = this.atEndIfMiss ? this.array.length : -1;
        }
        return order;
    }
}

