/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compiler;

import io.polaris.core.compiler.Compiler;
import io.polaris.core.compiler.MemoryClassLoader;
import io.polaris.core.compiler.MemoryJavaFileManager;
import io.polaris.core.compiler.MemoryStreamableJavaFileObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class MemoryCompiler
implements Compiler {
    private final JavaCompiler compiler;
    private final MemoryClassLoader memoryClassLoader;
    private final List<String> options = new ArrayList<String>();
    private final List<File> classPathFiles;

    public static MemoryCompiler getInstance() {
        return Holder.get(Thread.currentThread().getContextClassLoader());
    }

    public static MemoryCompiler getInstance(ClassLoader classLoader) {
        return Holder.get(classLoader);
    }

    public static List<String> defaultOption() {
        return Arrays.asList("-source", "1.8", "-target", "1.8", "-encoding", Charset.defaultCharset().name());
    }

    public MemoryCompiler() {
        this(Thread.currentThread().getContextClassLoader(), MemoryCompiler.defaultOption());
    }

    public MemoryCompiler(List<String> options) {
        this(Thread.currentThread().getContextClassLoader(), options);
    }

    public MemoryCompiler(ClassLoader parentClassLoader) {
        this(parentClassLoader, MemoryCompiler.defaultOption());
    }

    public MemoryCompiler(ClassLoader loader, List<String> options) {
        this.options.addAll(options);
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.memoryClassLoader = MemoryClassLoader.getInstance(loader);
        Set<String> classPaths = this.memoryClassLoader.getClassPaths();
        ArrayList<File> files = new ArrayList<File>();
        for (String classPath : classPaths) {
            files.add(new File(classPath));
        }
        this.classPathFiles = files;
    }

    @Nullable
    public byte[] getClassBytes(String name) {
        return this.memoryClassLoader.getMemoryClassBytes(name);
    }

    @Override
    public Class<?> compile(String className, String sourceCode) throws ClassNotFoundException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager manager = this.compiler.getStandardFileManager(diagnostics, null, null);
        try {
            manager.setLocation(StandardLocation.CLASS_PATH, this.classPathFiles);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        MemoryStreamableJavaFileObject javaFileObject = new MemoryStreamableJavaFileObject(className, (CharSequence)sourceCode);
        MemoryJavaFileManager javaFileManager = new MemoryJavaFileManager(manager, this.memoryClassLoader);
        javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, className, javaFileObject);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, javaFileManager, diagnostics, this.options, null, Collections.singletonList(javaFileObject));
        Boolean rs = task.call();
        if (rs == null || !rs.booleanValue()) {
            throw new IllegalStateException(this.compileError(className, diagnostics));
        }
        return this.memoryClassLoader.loadClass(className);
    }

    String compileError(String name, DiagnosticCollector<? super JavaFileObject> diagnostics) {
        StringBuilder sb = new StringBuilder();
        sb.append("Compilation error. class: ").append(name).append(" , diagnostics:\n");
        for (Diagnostic<? super JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            sb.append(diagnostic.toString()).append("\n");
        }
        return sb.toString();
    }

    String compileError(Diagnostic<?> diagnostic) {
        return diagnostic.toString();
    }

    private static class Holder {
        private static final Map<ClassLoader, MemoryCompiler> COMPILERS = new ConcurrentHashMap<ClassLoader, MemoryCompiler>();

        private Holder() {
        }

        public static MemoryCompiler get(ClassLoader classLoader) {
            classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            return COMPILERS.computeIfAbsent(classLoader, MemoryCompiler::new);
        }
    }
}

