/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.compiler;

import io.polaris.core.compiler.MemoryJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;

class MemoryStreamableJavaFileObject
extends MemoryJavaFileObject {
    private final CharSequence source;
    private ByteArrayOutputStream bout;

    public MemoryStreamableJavaFileObject(String classFullName, CharSequence source) {
        super(URI.create(classFullName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.source = source;
    }

    public MemoryStreamableJavaFileObject(URI uri, CharSequence source) {
        super(uri, JavaFileObject.Kind.SOURCE);
        this.source = source;
    }

    public MemoryStreamableJavaFileObject(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.source = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
        if (this.source == null) {
            throw new UnsupportedOperationException();
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        this.bout = new ByteArrayOutputStream();
        return this.bout;
    }

    @Override
    public byte[] getByteCode() {
        return this.bout == null ? null : this.bout.toByteArray();
    }
}

