/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.WrappingCallable;
import io.polaris.core.concurrent.WrappingExecutionListener;
import io.polaris.core.concurrent.WrappingInterceptor;
import io.polaris.core.concurrent.WrappingRunnable;
import io.polaris.core.concurrent.WrappingTaskFactory;
import java.util.concurrent.Callable;

public class DefaultWrappingTaskFactory
implements WrappingTaskFactory {
    private WrappingExecutionListener listener;
    private WrappingInterceptor interceptor;

    @Override
    public WrappingRunnable wrap(Runnable runnable) {
        return new DefaultWrappingTask(this.listener, this.interceptor, runnable);
    }

    @Override
    public <V> WrappingCallable<V> wrap(Callable<V> callable) {
        return new DefaultWrappingTask<V>(this.listener, this.interceptor, callable);
    }

    public WrappingExecutionListener getListener() {
        return this.listener;
    }

    public void setListener(WrappingExecutionListener listener) {
        this.listener = listener;
    }

    public WrappingInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(WrappingInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static class DefaultWrappingTask<V>
    implements WrappingRunnable,
    WrappingCallable<V>,
    WrappingExecutionListener {
        private final WrappingExecutionListener listener;
        private final WrappingInterceptor interceptor;
        private final Runnable runnable;
        private final Callable<V> callable;

        public DefaultWrappingTask(WrappingExecutionListener listener, WrappingInterceptor interceptor, Runnable runnable) {
            this.listener = listener;
            this.interceptor = interceptor;
            this.runnable = interceptor != null ? () -> {
                try {
                    interceptor.onBefore();
                    runnable.run();
                    interceptor.onAfter();
                }
                catch (Throwable e) {
                    interceptor.onThrowing(e);
                }
                finally {
                    interceptor.onFinally();
                }
            } : runnable;
            this.callable = null;
        }

        public DefaultWrappingTask(WrappingExecutionListener listener, WrappingInterceptor interceptor, Callable<V> callable) {
            this.listener = listener;
            this.interceptor = interceptor;
            this.callable = interceptor != null ? () -> {
                try {
                    interceptor.onBefore();
                    Object rs = callable.call();
                    interceptor.onAfter();
                    Object v = rs;
                    return v;
                }
                catch (Throwable e) {
                    interceptor.onThrowing(e);
                    throw e;
                }
                finally {
                    interceptor.onFinally();
                }
            } : callable;
            this.runnable = null;
        }

        @Override
        public void run() {
            if (this.runnable != null) {
                this.runnable.run();
            } else {
                try {
                    this.callable.call();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void beforeExecute(Thread t, Runnable r) {
            if (this.listener != null) {
                this.listener.beforeExecute(t, r);
            }
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            if (this.listener != null) {
                this.listener.afterExecute(r, t);
            }
        }

        @Override
        public V call() throws Exception {
            if (this.callable != null) {
                return this.callable.call();
            }
            this.runnable.run();
            return null;
        }
    }
}

