/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.Executors;
import io.polaris.core.concurrent.PooledThreadFactory;
import io.polaris.core.concurrent.WrappingScheduledThreadPoolExecutor;
import io.polaris.core.concurrent.WrappingTaskFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class Schedules {
    public static ScheduledExecutorService single() {
        return Schedules.single(null);
    }

    public static ScheduledExecutorService create(int core) {
        return Schedules.create(null, core);
    }

    public static ScheduledExecutorService create(int core, String threadNamePrefix) {
        return Schedules.create(null, core, threadNamePrefix, true);
    }

    public static ScheduledExecutorService create(int core, String threadNamePrefix, boolean isDaemon) {
        return Schedules.create(null, core, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ScheduledExecutorService create(int core, ThreadFactory threadFactory) {
        return Schedules.create(null, core, threadFactory);
    }

    public static ScheduledExecutorService single(WrappingTaskFactory wrappingTaskFactory) {
        if (wrappingTaskFactory != null) {
            WrappingScheduledThreadPoolExecutor executor = new WrappingScheduledThreadPoolExecutor(1);
            executor.setWrappedTaskFactory(wrappingTaskFactory);
            return executor;
        }
        return new ScheduledThreadPoolExecutor(1);
    }

    public static ScheduledExecutorService create(WrappingTaskFactory wrappingTaskFactory, int core) {
        if (wrappingTaskFactory != null) {
            WrappingScheduledThreadPoolExecutor executor = new WrappingScheduledThreadPoolExecutor(core);
            executor.setWrappedTaskFactory(wrappingTaskFactory);
            return executor;
        }
        return new ScheduledThreadPoolExecutor(core);
    }

    public static ScheduledExecutorService create(WrappingTaskFactory wrappingTaskFactory, int core, String threadNamePrefix, boolean isDaemon) {
        return Schedules.create(wrappingTaskFactory, core, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ScheduledExecutorService create(WrappingTaskFactory wrappingTaskFactory, int core, ThreadFactory threadFactory) {
        if (wrappingTaskFactory != null) {
            WrappingScheduledThreadPoolExecutor executor = new WrappingScheduledThreadPoolExecutor(core, threadFactory);
            executor.setWrappedTaskFactory(wrappingTaskFactory);
            return executor;
        }
        return new ScheduledThreadPoolExecutor(core, threadFactory);
    }

    public static void shutdown(ScheduledExecutorService pool) {
        Schedules.shutdown(pool, 60);
    }

    public static void shutdown(ScheduledExecutorService pool, int timeoutSeconds) {
        Executors.shutdown(pool, timeoutSeconds);
    }
}

