/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.Executors;
import io.polaris.core.concurrent.PooledThreadFactory;
import io.polaris.core.concurrent.WrappingTaskFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WrappingExecutors
extends Executors {
    private static WrappingTaskFactory defaultWrappingTaskFactory;

    public static WrappingTaskFactory getDefaultWrappingTaskFactory() {
        return defaultWrappingTaskFactory;
    }

    public static void setDefaultWrappingTaskFactory(WrappingTaskFactory defaultWrappingTaskFactory) {
        WrappingExecutors.defaultWrappingTaskFactory = defaultWrappingTaskFactory;
    }

    public static ThreadPoolExecutor create(int core, String threadNamePrefix) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, core, threadNamePrefix, true);
    }

    public static ThreadPoolExecutor create(int core, int max, String threadNamePrefix) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, threadNamePrefix, true);
    }

    public static ThreadPoolExecutor create(int core, String threadNamePrefix, boolean isDaemon) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, core, WrappingExecutors.createDefaultBlockingQueue(), threadNamePrefix, isDaemon);
    }

    public static ThreadPoolExecutor create(int core, int max, String threadNamePrefix, boolean isDaemon) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, WrappingExecutors.createDefaultBlockingQueue(), threadNamePrefix, isDaemon);
    }

    public static ThreadPoolExecutor create(int core, BlockingQueue<Runnable> blockingQueue, String threadNamePrefix, boolean isDaemon) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, core, blockingQueue, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ThreadPoolExecutor create(int core, int max, BlockingQueue<Runnable> blockingQueue, String threadNamePrefix, boolean isDaemon) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, blockingQueue, new PooledThreadFactory().withPrefix(threadNamePrefix).withDaemon(isDaemon));
    }

    public static ThreadPoolExecutor create(int core, ThreadFactory threadFactory) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, core, WrappingExecutors.createDefaultBlockingQueue(), threadFactory);
    }

    public static ThreadPoolExecutor create(int core, int max, ThreadFactory threadFactory) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, WrappingExecutors.createDefaultBlockingQueue(), threadFactory);
    }

    public static ThreadPoolExecutor create(int core, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, core, blockingQueue, threadFactory);
    }

    public static ThreadPoolExecutor create(int core, int max, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, blockingQueue, threadFactory);
    }

    public static ThreadPoolExecutor create(int core, int max, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return WrappingExecutors.create(defaultWrappingTaskFactory, core, max, keepAliveTime, unit, blockingQueue, threadFactory);
    }
}

