/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.WrappingTask;
import io.polaris.core.concurrent.WrappingTaskFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class WrappingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private WrappingTaskFactory wrappedTaskFactory;

    public WrappingScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public WrappingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public WrappingScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public WrappingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public WrappingTaskFactory getWrappedTaskFactory() {
        return this.wrappedTaskFactory;
    }

    public void setWrappedTaskFactory(WrappingTaskFactory wrappedTaskFactory) {
        this.wrappedTaskFactory = wrappedTaskFactory;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command != null && !(command instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            command = this.wrappedTaskFactory.wrap(command);
        }
        return super.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable != null && !(callable instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            callable = this.wrappedTaskFactory.wrap(callable);
        }
        return super.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command != null && !(command instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            command = this.wrappedTaskFactory.wrap(command);
        }
        return super.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command != null && !(command instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            command = this.wrappedTaskFactory.wrap(command);
        }
        return super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (command != null && !(command instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            command = this.wrappedTaskFactory.wrap(command);
        }
        super.execute(command);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable != null && !(runnable instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            runnable = this.wrappedTaskFactory.wrap(runnable);
        }
        return new FutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable != null && !(callable instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            callable = this.wrappedTaskFactory.wrap(callable);
        }
        return new FutureTask<T>(callable);
    }
}

