/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent;

import io.polaris.core.concurrent.WrappingExecutionListener;
import io.polaris.core.concurrent.WrappingTask;
import io.polaris.core.concurrent.WrappingTaskFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WrappingThreadPoolExecutor
extends ThreadPoolExecutor {
    private WrappingTaskFactory wrappedTaskFactory;

    public WrappingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public WrappingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public WrappingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public WrappingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public WrappingTaskFactory getWrappedTaskFactory() {
        return this.wrappedTaskFactory;
    }

    public void setWrappedTaskFactory(WrappingTaskFactory wrappedTaskFactory) {
        this.wrappedTaskFactory = wrappedTaskFactory;
    }

    @Override
    public void execute(Runnable command) {
        if (command != null && !(command instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            command = this.wrappedTaskFactory.wrap(command);
        }
        super.execute(command);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable != null && !(runnable instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            runnable = this.wrappedTaskFactory.wrap(runnable);
        }
        return new FutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable != null && !(callable instanceof WrappingTask) && this.wrappedTaskFactory != null) {
            callable = this.wrappedTaskFactory.wrap(callable);
        }
        return new FutureTask<T>(callable);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (r instanceof WrappingExecutionListener) {
            ((WrappingExecutionListener)((Object)r)).beforeExecute(t, r);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (r instanceof WrappingExecutionListener) {
            ((WrappingExecutionListener)((Object)r)).afterExecute(r, t);
        }
    }
}

