/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.queue;

import java.util.concurrent.TimeUnit;

public class MemoryLimitCalculator {
    private static final long refreshInterval = TimeUnit.MILLISECONDS.toNanos(50L);
    private static volatile long refreshTime;
    private static volatile long maxAvailable;

    private static void checkAndRefresh() {
        long now = System.nanoTime();
        if (now - refreshTime >= refreshInterval) {
            refreshTime = now;
            maxAvailable = Runtime.getRuntime().freeMemory();
        }
    }

    public static long maxAvailable() {
        MemoryLimitCalculator.checkAndRefresh();
        return maxAvailable;
    }

    public static long calculate(double percentage) {
        MemoryLimitCalculator.checkAndRefresh();
        if (percentage <= 0.0) {
            return 0L;
        }
        if (percentage >= 1.0) {
            return MemoryLimitCalculator.maxAvailable();
        }
        return (long)((double)MemoryLimitCalculator.maxAvailable() * percentage);
    }

    public static long defaultLimit() {
        MemoryLimitCalculator.checkAndRefresh();
        return (long)((double)MemoryLimitCalculator.maxAvailable() * 0.8);
    }
}

