/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.queue;

import io.polaris.core.concurrent.queue.MemoryLimitCalculator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MemorySafeLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 8032578371739960142L;
    public static int THE_256_MB = 0x10000000;
    private int maxFreeMemory;
    private double maxPercentage = 0.8;

    public MemorySafeLinkedBlockingQueue() {
        this(THE_256_MB);
    }

    public MemorySafeLinkedBlockingQueue(int maxFreeMemory) {
        super(Integer.MAX_VALUE);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLinkedBlockingQueue(int maxFreeMemory, double maxPercentage) {
        super(Integer.MAX_VALUE);
        this.maxFreeMemory = maxFreeMemory;
        this.maxPercentage = maxPercentage;
    }

    public boolean hasRemainedMemory() {
        return MemoryLimitCalculator.calculate(this.maxPercentage) > (long)this.maxFreeMemory;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (!this.hasRemainedMemory()) {
            throw new InterruptedException("no free memory");
        }
        super.put(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.hasRemainedMemory()) {
            return false;
        }
        return super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        if (!this.hasRemainedMemory()) {
            return false;
        }
        return super.offer(e);
    }

    public void setMaxFreeMemory(int maxFreeMemory) {
        this.maxFreeMemory = maxFreeMemory;
    }

    public int getMaxFreeMemory() {
        return this.maxFreeMemory;
    }

    public void setMaxPercentage(double maxPercentage) {
        this.maxPercentage = maxPercentage;
    }

    public double getMaxPercentage() {
        return this.maxPercentage;
    }
}

