/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.collection.Iterables;
import io.polaris.core.converter.AbstractConverter;
import io.polaris.core.json.JsonSerializer;
import io.polaris.core.lang.JavaType;
import io.polaris.core.service.StatefulServiceLoader;
import java.util.Optional;

public abstract class AbstractSimpleConverter<T>
extends AbstractConverter<T> {
    @Override
    protected final <S> T doConvert(S value, JavaType<T> targetType, JavaType<S> sourceType) {
        return this.doConvert(value, targetType);
    }

    protected abstract T doConvert(Object var1, JavaType<T> var2);

    protected String asComplexString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        Optional<JsonSerializer> optional = StatefulServiceLoader.load(JsonSerializer.class).optionalService();
        if (optional.isPresent()) {
            return optional.get().serialize(value);
        }
        if (value.getClass().isArray()) {
            return Iterables.toArrayString(value);
        }
        return value.toString();
    }

    protected String asSimpleString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        return value.toString();
    }
}

