/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.converter.Converter;
import io.polaris.core.converter.ConverterRegistry;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class Converters {
    private static volatile ConverterRegistry defaultRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConverterRegistry getDefaultRegistry() {
        if (defaultRegistry != null) {
            return defaultRegistry;
        }
        Class<Converters> clazz = Converters.class;
        synchronized (Converters.class) {
            if (defaultRegistry == null) {
                defaultRegistry = new ConverterRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultRegistry;
        }
    }

    @Nullable
    public static <T> Converter<T> getConverter(Type type) {
        return Converters.getDefaultRegistry().getConverter(type);
    }

    public static <T> Converter<T> getConverterOrDefault(Type type, Converter<T> defaults) {
        return Converters.getDefaultRegistry().getConverterOrDefault(type, defaults);
    }

    public static <T> T convert(Type type, Type valueType, Object value, T defaultValue) {
        return Converters.getDefaultRegistry().convert(type, valueType, value, defaultValue);
    }

    public static <T> T convert(Type type, Type valueType, Object value) {
        return Converters.getDefaultRegistry().convert(type, valueType, value);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) {
        return Converters.getDefaultRegistry().convert(type, value, defaultValue);
    }

    @AnnotationProcessing
    public static <T> T convert(Type type, Object value) {
        return Converters.getDefaultRegistry().convert(type, value);
    }

    public static <T> T convertQuietly(Type type, Type valueType, Object value, T defaultValue) {
        return Converters.getDefaultRegistry().convertQuietly(type, valueType, value, defaultValue);
    }

    public static <T> T convertQuietly(Type type, Type valueType, Object value) {
        return Converters.getDefaultRegistry().convertQuietly(type, valueType, value);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return Converters.getDefaultRegistry().convertQuietly(type, value, defaultValue);
    }

    public static <T> T convertQuietly(Type type, Object value) {
        return Converters.getDefaultRegistry().convertQuietly(type, value);
    }

    public static <T> T convertByPropertyEditor(Class<?> type, Object value, T defaultValue) {
        PropertyEditor sourceEditor = PropertyEditorManager.findEditor(value.getClass());
        PropertyEditor targetEditor = PropertyEditorManager.findEditor(type);
        if (sourceEditor != null && targetEditor != null) {
            sourceEditor.setValue(value);
            targetEditor.setAsText(sourceEditor.getAsText());
            return (T)targetEditor.getValue();
        }
        return defaultValue;
    }
}

