/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import java.lang.reflect.Method;

public class EnumConverter<T extends Enum<T>>
extends AbstractSimpleConverter<T> {
    private static final ILogger log = ILoggers.of(EnumConverter.class);
    private static final String[] parseMethodNames = new String[]{"parseOf", "parse", "of"};
    private final JavaType<T> targetType;
    private final Class<T> enumClass;
    private final Method parseMethod;

    public EnumConverter(Class<T> enumClass) {
        this.targetType = JavaType.of(enumClass);
        this.enumClass = enumClass;
        Method method = null;
        for (String name : parseMethodNames) {
            method = Reflects.getInheritableStaticMethod(enumClass, name, new Class[]{String.class}, enumClass);
            if (method != null) break;
        }
        this.parseMethod = method;
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected T doConvert(Object value, JavaType<T> targetType) {
        Enum rs;
        block9: {
            String str;
            block8: {
                if (value == null) {
                    return null;
                }
                if (value instanceof Number) {
                    int i = ((Number)value).intValue();
                    Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
                    return (T)(i >= 0 && i < enumConstants.length ? enumConstants[i] : null);
                }
                str = this.asSimpleString(value);
                rs = null;
                if (this.parseMethod != null) {
                    try {
                        rs = (Enum)Reflects.invokeStatic(this.parseMethod, str);
                        if (rs != null) {
                            return (T)rs;
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug("\u679a\u4e3e\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a{}", e.getMessage(), e);
                    }
                }
            }
            try {
                rs = (Enum)Enum.valueOf(targetType.getRawClass(), str);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug("\u679a\u4e3e\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a{}", e.getMessage(), e);
            }
        }
        return (T)rs;
    }
}

