/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.time.Dates;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarConverter
extends AbstractSimpleConverter<Calendar> {
    private String format;

    public CalendarConverter() {
    }

    public CalendarConverter(String format) {
        this.format = format;
    }

    @Override
    public JavaType<Calendar> getTargetType() {
        return JavaType.of(Calendar.class);
    }

    @Override
    protected Calendar doConvert(Object value, JavaType<Calendar> targetType) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        if (value instanceof Date) {
            cal.setTimeInMillis(((Date)value).getTime());
        } else if (value instanceof Long) {
            cal.setTimeInMillis((Long)value);
        } else {
            String valueStr = this.asSimpleString(value);
            Date date = Dates.parseDate(valueStr);
            cal.setTime(date);
        }
        return cal;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }
}

