/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.string.Strings;

public class CharacterConverter
extends AbstractSimpleConverter<Character> {
    private final JavaType<Character> targetType = JavaType.of(Character.class);

    @Override
    public JavaType<Character> getTargetType() {
        return this.targetType;
    }

    @Override
    protected Character doConvert(Object value, JavaType<Character> targetType) {
        if (value instanceof Boolean) {
            return Character.valueOf(Boolean.TRUE.equals(value) ? (char)'\u0001' : '\u0000');
        }
        String valueStr = this.asSimpleString(value);
        return Strings.isBlank(valueStr) ? null : Character.valueOf(valueStr.charAt(0));
    }
}

