/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;
import io.polaris.core.string.Strings;
import io.polaris.core.time.Dates;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter<T extends Date>
extends AbstractSimpleConverter<T> {
    private final JavaType<T> targetType;
    private String format;

    public DateConverter(JavaType<T> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<T> targetType) {
        this.targetType = JavaType.of(targetType);
    }

    public DateConverter(Class<T> targetType, String format) {
        this.targetType = JavaType.of(targetType);
        this.format = format;
    }

    public DateConverter(JavaType<T> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected T doConvert(Object value, JavaType<T> type) {
        if (value == null || value instanceof CharSequence && Strings.isBlank(value.toString())) {
            return null;
        }
        Class<T> rawClass = type.getRawClass();
        Date date = this.parseDate(value);
        if (Date.class == rawClass) {
            return (T)date;
        }
        if (java.sql.Date.class == rawClass) {
            return (T)new java.sql.Date(date.getTime());
        }
        if (Time.class == rawClass) {
            return (T)new Time(date.getTime());
        }
        if (Timestamp.class == rawClass) {
            return (T)new Timestamp(date.getTime());
        }
        return (T)date;
    }

    private Date parseDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof TemporalAccessor) {
            return Dates.toDate((TemporalAccessor)value);
        }
        if (value instanceof Calendar) {
            return Dates.toDate(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Number) {
            return Dates.toDate(((Number)value).longValue());
        }
        String valueStr = this.asSimpleString(value);
        Date date = Strings.isBlank(this.format) ? Dates.parseDate(valueStr) : Dates.parseDate(this.format, valueStr);
        return date;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

