/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.converter.ConversionException;
import io.polaris.core.lang.JavaType;
import io.polaris.core.string.Strings;
import io.polaris.core.time.Dates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnull;

public class NumberConverter<T extends Number>
extends AbstractSimpleConverter<T> {
    protected final JavaType<T> targetType;

    public NumberConverter() {
        this.targetType = JavaType.of(Number.class);
    }

    public NumberConverter(@Nonnull Class<T> targetType) {
        if (targetType == null) {
            throw new NullPointerException();
        }
        this.targetType = JavaType.of(targetType);
    }

    @Override
    public JavaType<T> getTargetType() {
        return this.targetType;
    }

    @Override
    protected T doConvert(Object value, JavaType<T> type) {
        if (value instanceof Enum) {
            return (T)this.doConvert((Object)((Enum)value).ordinal(), (JavaType)type);
        }
        Class<T> targetType = type.getRawClass();
        if (Byte.class == targetType) {
            return (T)this.toByte(value);
        }
        if (Short.class == targetType) {
            return (T)this.toShort(value);
        }
        if (Integer.class == targetType) {
            return (T)this.toInteger(value);
        }
        if (AtomicInteger.class == targetType) {
            return (T)new AtomicInteger(this.toInteger(value));
        }
        if (Long.class == targetType) {
            return (T)this.toLong(value);
        }
        if (AtomicLong.class == targetType) {
            return (T)new AtomicLong(this.toLong(value));
        }
        if (LongAdder.class == targetType) {
            LongAdder longValue = new LongAdder();
            longValue.add(this.toLong(value));
            return (T)longValue;
        }
        if (Float.class == targetType) {
            return (T)this.toFloat(value);
        }
        if (Double.class == targetType) {
            return (T)this.toDouble(value);
        }
        if (DoubleAdder.class == targetType) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(this.toDouble(value));
            return (T)doubleAdder;
        }
        if (BigDecimal.class == targetType) {
            return (T)this.toBigDecimal(value);
        }
        if (BigInteger.class == targetType) {
            return (T)this.toBigInteger(value);
        }
        if (Number.class == targetType) {
            if (value instanceof Number) {
                return (T)((Number)value);
            }
            if (value instanceof Boolean) {
                return (T)((Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            return (T)this.parseNumber(this.asSimpleString(value));
        }
        return null;
    }

    public Byte toByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        String str = this.asSimpleString(value);
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException e) {
            return this.parseNumber(str).byteValue();
        }
    }

    @Nonnull
    public Short toShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        String str = this.asSimpleString(value);
        try {
            return Short.valueOf(str);
        }
        catch (NumberFormatException e) {
            return this.parseNumber(str).shortValue();
        }
    }

    @Nonnull
    public Integer toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if (value instanceof Date) {
            return (int)((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return (int)((Calendar)value).getTimeInMillis();
        }
        if (value instanceof TemporalAccessor) {
            return (int)Dates.toMills(Dates.toLocalDateTime((TemporalAccessor)value));
        }
        String str = this.asSimpleString(value);
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return this.parseNumber(str).intValue();
        }
    }

    public Long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof TemporalAccessor) {
            return Dates.toMills(Dates.toLocalDateTime((TemporalAccessor)value));
        }
        String str = this.asSimpleString(value);
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return this.parseNumber(str).longValue();
        }
    }

    public Float toFloat(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
        }
        String str = this.asSimpleString(value);
        try {
            return Float.valueOf(str);
        }
        catch (NumberFormatException e) {
            return Float.valueOf(this.parseNumber(str).floatValue());
        }
    }

    public Double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
        }
        String str = this.asSimpleString(value);
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return this.parseNumber(str).doubleValue();
        }
    }

    public Number parseNumber(String str) {
        if ((str = Strings.trimToNull(str)) == null) {
            return 0L;
        }
        try {
            return Long.decode(str);
        }
        catch (Exception exception) {
            try {
                NumberFormat format = NumberFormat.getInstance();
                if (format instanceof DecimalFormat) {
                    ((DecimalFormat)format).setParseBigDecimal(true);
                }
                return format.parse(str);
            }
            catch (Exception exception2) {
                throw new ConversionException("\u6570\u503c\u5b57\u7b26\u4e32\u65e0\u6cd5\u89e3\u6790\uff1a" + str);
            }
        }
    }

    public BigDecimal toBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return this.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String str = this.asSimpleString(value);
        Number number = this.parseNumber(str);
        if (number != null) {
            return this.toBigDecimal(number);
        }
        return new BigDecimal(str);
    }

    public BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.toString());
    }

    public BigInteger toBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String str = Strings.trimToNull(this.asSimpleString(value));
        if (str == null) {
            return BigInteger.ZERO;
        }
        Number number = this.parseNumber(str);
        if (number != null) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        return new BigInteger(str);
    }
}

