/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.lang.JavaType;
import java.io.File;
import java.net.URI;
import java.net.URL;

public class URLConverter
extends AbstractSimpleConverter<URL> {
    private final JavaType<URL> targetType = JavaType.of(URL.class);

    @Override
    public JavaType<URL> getTargetType() {
        return this.targetType;
    }

    @Override
    protected URL doConvert(Object value, JavaType<URL> targetType) {
        try {
            if (value instanceof File) {
                return ((File)value).toURI().toURL();
            }
            if (value instanceof URI) {
                return ((URI)value).toURL();
            }
            return new URL(this.asSimpleString(value));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

