/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.asymmetric;

import io.polaris.core.crypto.Ciphers;
import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.IDecryptor;
import io.polaris.core.crypto.IEncryptor;
import io.polaris.core.crypto.asymmetric.AsymmetricAlgorithm;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class Asymmetric {
    private final String provider;
    private final String algorithm;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private IEncryptor encryptor;
    private IDecryptor decryptor;

    public Asymmetric(String provider, String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.provider = provider;
        this.algorithm = algorithm;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static Asymmetric of(String provider, String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return new Asymmetric(provider, algorithm, privateKey, publicKey);
    }

    public static Asymmetric of(String provider, String algorithm, KeyPair keyPair) {
        return Asymmetric.of(provider, algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Asymmetric of(String provider, String algorithm) {
        return Asymmetric.of(provider, algorithm, CryptoKeys.generateKeyPair(algorithm));
    }

    public static Asymmetric of(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Asymmetric.of(null, algorithm, privateKey, publicKey);
    }

    public static Asymmetric of(String algorithm, KeyPair keyPair) {
        return Asymmetric.of(null, algorithm, keyPair);
    }

    public static Asymmetric of(String algorithm) {
        return Asymmetric.of(null, algorithm);
    }

    public static Asymmetric of(String provider, AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Asymmetric.of(provider, algorithm.code(), privateKey, publicKey);
    }

    public static Asymmetric of(String provider, AsymmetricAlgorithm algorithm, KeyPair keyPair) {
        return Asymmetric.of(provider, algorithm.code(), keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Asymmetric of(String provider, AsymmetricAlgorithm algorithm) {
        return Asymmetric.of(provider, algorithm.code(), CryptoKeys.generateKeyPair(algorithm.code()));
    }

    public static Asymmetric of(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Asymmetric.of(null, algorithm.code(), privateKey, publicKey);
    }

    public static Asymmetric of(AsymmetricAlgorithm algorithm, KeyPair keyPair) {
        return Asymmetric.of(null, algorithm.code(), keyPair);
    }

    public static Asymmetric of(AsymmetricAlgorithm algorithm) {
        return Asymmetric.of(null, algorithm.code());
    }

    public IDecryptor getDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = this.provider == null ? Ciphers.getDecryptor(this.algorithm, this.privateKey) : Ciphers.getDecryptor(this.provider, this.algorithm, (Key)this.privateKey);
        }
        return this.decryptor;
    }

    public IEncryptor getEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = this.provider == null ? Ciphers.getEncryptor(this.algorithm, this.publicKey) : Ciphers.getEncryptor(this.provider, this.algorithm, (Key)this.privateKey);
        }
        return this.encryptor;
    }

    public Asymmetric encryptUpdate(byte[] data) {
        this.getEncryptor().update(data);
        return this;
    }

    public byte[] encrypt(byte[] data) {
        return this.getEncryptor().encrypt(data);
    }

    public Asymmetric decryptUpdate(byte[] data) {
        this.getDecryptor().update(data);
        return this;
    }

    public byte[] decrypt(byte[] data) {
        return this.getDecryptor().decrypt(data);
    }
}

