/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.asymmetric;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.CryptoRuntimeException;
import io.polaris.core.crypto.asymmetric.SignAlgorithm;
import io.polaris.core.crypto.asymmetric.Signatures;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class Sign {
    private final String provider;
    private final String algorithm;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private Signature signSignature;
    private Signature verifySignature;

    public Sign(String provider, String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.provider = provider;
        this.algorithm = algorithm;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static Sign of(String provider, String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return new Sign(provider, algorithm, privateKey, publicKey);
    }

    public static Sign of(String provider, String algorithm, KeyPair keyPair) {
        return Sign.of(provider, algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Sign of(String provider, String algorithm) {
        return Sign.of(provider, algorithm, CryptoKeys.generateKeyPair(provider, algorithm));
    }

    public static Sign of(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Sign.of(null, algorithm, privateKey, publicKey);
    }

    public static Sign of(String algorithm, KeyPair keyPair) {
        return Sign.of(null, algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Sign of(String algorithm) {
        return Sign.of(null, algorithm);
    }

    public static Sign of(String provider, SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Sign.of(provider, algorithm.code(), privateKey, publicKey);
    }

    public static Sign of(String provider, SignAlgorithm algorithm, KeyPair keyPair) {
        return Sign.of(provider, algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Sign of(String provider, SignAlgorithm algorithm) {
        return Sign.of(provider, algorithm, CryptoKeys.generateKeyPair(provider, algorithm.code()));
    }

    public static Sign of(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        return Sign.of(null, algorithm, privateKey, publicKey);
    }

    public static Sign of(SignAlgorithm algorithm, KeyPair keyPair) {
        return Sign.of(null, algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public static Sign of(SignAlgorithm algorithm) {
        return Sign.of(null, algorithm);
    }

    public Sign signUpdate(byte[] data) {
        try {
            this.getSignSignature().update(data);
            return this;
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public byte[] sign(byte[] data) {
        return this.signUpdate(data).sign();
    }

    public byte[] sign() {
        try {
            return this.getSignSignature().sign();
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public Sign verifyUpdate(byte[] data) {
        try {
            this.getVerifySignature().update(data);
            return this;
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public boolean verify(byte[] data, byte[] signature) {
        return this.verifyUpdate(data).verify(signature);
    }

    public boolean verify(byte[] signature) {
        try {
            return this.getVerifySignature().verify(signature);
        }
        catch (SignatureException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public Signature getSignSignature() {
        if (this.signSignature == null) {
            this.signSignature = Signatures.getInitializedSignature(this.algorithm, this.privateKey);
        }
        return this.signSignature;
    }

    public Signature getVerifySignature() {
        if (this.verifySignature == null) {
            this.verifySignature = Signatures.getInitializedSignature(this.algorithm, this.publicKey);
        }
        return this.verifySignature;
    }
}

