/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.digest;

import io.polaris.core.crypto.digest.Hmacs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.crypto.Mac;

public class Hmac {
    private final Mac mac;

    public Hmac(Mac mac) {
        this.mac = mac;
    }

    public Hmac(String algorithm, byte[] key) {
        this(Hmacs.getInitializedMac(algorithm, key));
    }

    public Hmac update(byte[] bytes) throws IllegalStateException {
        this.mac.update(bytes);
        return this;
    }

    public Hmac update(ByteBuffer byteBuffer) {
        this.mac.update(byteBuffer);
        return this;
    }

    public Hmac update(InputStream data) throws IOException {
        Hmacs.updateHmac(this.mac, data);
        return this;
    }

    public byte[] doFinal() throws IllegalStateException {
        return this.mac.doFinal();
    }

    public byte[] doFinal(byte[] bytes) throws IllegalStateException {
        return this.mac.doFinal(bytes);
    }

    public byte[] doFinal(ByteBuffer byteBuffer) throws IllegalStateException {
        return this.update(byteBuffer).doFinal();
    }

    public Mac getMac() {
        return this.mac;
    }
}

