/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.otp;

import io.polaris.core.crypto.otp.GoogleAuthenticatorException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

class ReseedingSecureRandom {
    private static final int MAX_OPERATIONS = 1000000;
    private final String provider;
    private final String algorithm;
    private final AtomicInteger count = new AtomicInteger(0);
    private volatile SecureRandom secureRandom;

    ReseedingSecureRandom() {
        this.algorithm = null;
        this.provider = null;
        this.buildSecureRandom();
    }

    ReseedingSecureRandom(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null.");
        }
        this.algorithm = algorithm;
        this.provider = null;
        this.buildSecureRandom();
    }

    ReseedingSecureRandom(String algorithm, String provider) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null.");
        }
        this.algorithm = algorithm;
        this.provider = provider;
        this.buildSecureRandom();
    }

    private void buildSecureRandom() {
        try {
            this.secureRandom = this.algorithm == null && this.provider == null ? new SecureRandom() : (this.provider == null ? SecureRandom.getInstance(this.algorithm) : SecureRandom.getInstance(this.algorithm, this.provider));
        }
        catch (NoSuchAlgorithmException e) {
            throw new GoogleAuthenticatorException(String.format("Could not initialise SecureRandom with the specified algorithm: %s. Another provider can be chosen setting the %s system property.", this.algorithm, "googleauth.rng.algorithm"), e);
        }
        catch (NoSuchProviderException e) {
            throw new GoogleAuthenticatorException(String.format("Could not initialise SecureRandom with the specified provider: %s. Another provider can be chosen setting the %s system property.", this.provider, "googleauth.rng.algorithmProvider"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nextBytes(byte[] bytes) {
        if (this.count.incrementAndGet() > 1000000) {
            ReseedingSecureRandom reseedingSecureRandom = this;
            synchronized (reseedingSecureRandom) {
                if (this.count.get() > 1000000) {
                    this.buildSecureRandom();
                    this.count.set(0);
                }
            }
        }
        this.secureRandom.nextBytes(bytes);
    }
}

