/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.symmetric;

import io.polaris.core.crypto.Ciphers;
import io.polaris.core.crypto.symmetric.SymmetricAlgorithm;
import java.util.Arrays;

public class AES {
    public static byte[] paddingKey(byte[] key) {
        return AES.paddingKey(key, (byte)key.length);
    }

    public static byte[] paddingKey(byte[] key, byte pad) {
        if (key.length == 16 || key.length == 24 || key.length == 32) {
            return key;
        }
        int newLength = 32;
        if (key.length < 16) {
            newLength = 16;
        } else if (key.length < 24) {
            newLength = 24;
        }
        byte[] newKey = new byte[newLength];
        System.arraycopy(key, 0, newKey, 0, Integer.min(key.length, newLength));
        if (newLength > key.length) {
            Arrays.fill(newKey, key.length, newLength, pad);
        }
        return newKey;
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        return Ciphers.encrypt(SymmetricAlgorithm.AES.code(), key, data);
    }

    public static byte[] encryptByKeySeed(byte[] data, byte[] key) {
        return Ciphers.encryptByKeySeed(SymmetricAlgorithm.AES.code(), key, data);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        return Ciphers.decrypt(SymmetricAlgorithm.AES.code(), key, data);
    }

    public static byte[] decryptByKeySeed(byte[] data, byte[] key) {
        return Ciphers.decryptByKeySeed(SymmetricAlgorithm.AES.code(), key, data);
    }
}

