/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.symmetric;

import io.polaris.core.crypto.Ciphers;
import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.IDecryptor;
import io.polaris.core.crypto.IEncryptor;
import io.polaris.core.crypto.symmetric.SymmetricAlgorithm;
import java.security.Key;

public class Symmetric {
    private final String provider;
    private final String algorithm;
    private final Key key;
    private IEncryptor encryptor;
    private IDecryptor decryptor;

    public Symmetric(String provider, String algorithm, Key key) {
        this.provider = provider;
        this.algorithm = algorithm;
        if (key == null) {
            key = provider == null ? CryptoKeys.generateKey(algorithm) : CryptoKeys.generateKey(provider, algorithm);
        }
        this.key = key;
    }

    public static Symmetric of(String provider, String algorithm, Key key) {
        return new Symmetric(provider, algorithm, key);
    }

    public static Symmetric of(String provider, String algorithm) {
        return Symmetric.of(provider, algorithm, (Key)CryptoKeys.generateKey(provider, algorithm));
    }

    public static Symmetric of(String algorithm, Key key) {
        return Symmetric.of(null, algorithm, key);
    }

    public static Symmetric of(String algorithm) {
        return Symmetric.of(null, algorithm, (Key)CryptoKeys.generateKey(algorithm));
    }

    public static Symmetric of(String provider, SymmetricAlgorithm algorithm, Key key) {
        return new Symmetric(provider, algorithm.code(), key);
    }

    public static Symmetric of(String provider, SymmetricAlgorithm algorithm) {
        return Symmetric.of(provider, algorithm, (Key)CryptoKeys.generateKey(provider, algorithm.code()));
    }

    public static Symmetric of(SymmetricAlgorithm algorithm, Key key) {
        return Symmetric.of(null, algorithm.code(), key);
    }

    public static Symmetric of(SymmetricAlgorithm algorithm) {
        return Symmetric.of(null, algorithm, (Key)CryptoKeys.generateKey(algorithm.code()));
    }

    public IDecryptor getDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = Ciphers.getDecryptor(this.algorithm, this.key);
        }
        return this.decryptor;
    }

    public IEncryptor getEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = Ciphers.getEncryptor(this.algorithm, this.key);
        }
        return this.encryptor;
    }

    public Symmetric encryptUpdate(byte[] data) {
        this.getEncryptor().update(data);
        return this;
    }

    public byte[] encrypt(byte[] data) {
        return this.getEncryptor().encrypt(data);
    }

    public Symmetric decryptUpdate(byte[] data) {
        this.getDecryptor().update(data);
        return this;
    }

    public byte[] decrypt(byte[] data) {
        return this.getDecryptor().decrypt(data);
    }
}

