/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data.buffer;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicRangeInteger
extends Number
implements Serializable {
    private static final int VALUE_LENGTH = 31;
    private static final int VALUE_OFFSET = 15;
    private final AtomicIntegerArray values = new AtomicIntegerArray(31);
    private int startValue;
    private int endValue;

    public AtomicRangeInteger(int startValue, int maxValue) {
        this.values.set(15, startValue);
        this.startValue = startValue;
        this.endValue = maxValue - 1;
    }

    public final int getAndIncrement() {
        int next;
        do {
            if ((next = this.values.incrementAndGet(15)) <= this.endValue || !this.values.compareAndSet(15, next, this.startValue)) continue;
            return this.endValue;
        } while (next > this.endValue);
        return next - 1;
    }

    public final int get() {
        return this.values.get(15);
    }

    @Override
    public int intValue() {
        return this.values.get(15);
    }

    @Override
    public long longValue() {
        return this.values.get(15);
    }

    @Override
    public float floatValue() {
        return this.values.get(15);
    }

    @Override
    public double doubleValue() {
        return this.values.get(15);
    }
}

