/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.Env;
import io.polaris.core.env.GroupEnv;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class FileEnv
implements Env {
    private final String name;
    private final Env delegate;

    public FileEnv(String name, String propertyFile) {
        this.name = name;
        this.delegate = this.loadProperties(name, propertyFile);
    }

    private Env loadProperties(String name, String propertyFile) {
        if (propertyFile != null) {
            GroupEnv group = GroupEnv.newInstance(name);
            try {
                try (FileInputStream fis2 = new FileInputStream(propertyFile);){
                    Properties properties = new Properties();
                    properties.load(fis2);
                    if (!properties.isEmpty()) {
                        group.addEnvLast(Env.wrap(properties));
                    }
                }
                catch (IOException fis2) {
                    // empty catch block
                }
                Properties propInDir = null;
                Properties propInJar = null;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> urls = classLoader.getResources(propertyFile);
                while (urls.hasMoreElements()) {
                    Properties prop;
                    URL url = urls.nextElement();
                    if ("file".equals(url.getProtocol())) {
                        if (propInDir == null) {
                            propInDir = new Properties();
                        }
                        prop = propInDir;
                    } else {
                        if (propInJar == null) {
                            propInJar = new Properties();
                        }
                        prop = propInJar;
                    }
                    try {
                        InputStream in = url.openStream();
                        Throwable throwable = null;
                        try {
                            Properties properties = new Properties();
                            properties.load(in);
                            if (properties.isEmpty()) continue;
                            for (String key : properties.stringPropertyNames()) {
                                prop.putIfAbsent(key, properties.get(key));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (propInDir != null) {
                    group.addEnvLast(Env.wrap(propInDir));
                }
                if (propInJar != null) {
                    group.addEnvLast(Env.wrap(propInJar));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return group;
        }
        return null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void set(String key, String value) {
        if (this.delegate != null) {
            this.delegate.set(key, value);
        }
    }

    @Override
    public void remove(String key) {
        if (this.delegate != null) {
            this.delegate.remove(key);
        }
    }

    @Override
    public String get(String key, String defaultValue) {
        if (this.delegate != null) {
            return this.delegate.get(key, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public String get(String key) {
        if (this.delegate != null) {
            return this.delegate.get(key);
        }
        return null;
    }

    @Override
    public Set<String> keys() {
        if (this.delegate != null) {
            return this.delegate.keys();
        }
        return Collections.emptySet();
    }

    @Override
    public Properties asProperties() {
        if (this.delegate != null) {
            return this.delegate.asProperties();
        }
        return new Properties();
    }

    @Override
    public Map<String, String> asMap() {
        if (this.delegate != null) {
            return this.delegate.asMap();
        }
        return new HashMap<String, String>();
    }
}

