/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.Env;
import io.polaris.core.lang.primitive.Booleans;
import io.polaris.core.string.Strings;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class GroupEnv
implements Env {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final String name;
    private final CopyOnWriteArrayList<Env> envList = new CopyOnWriteArrayList();
    private final ThreadLocal<Deque<String>> resolvedKeys = new ThreadLocal();
    private final ThreadLocal<Boolean> retrieved = new ThreadLocal();
    private Env runtime;

    private GroupEnv(String name, boolean mutable) {
        this.name = name;
        if (mutable) {
            this.runtime = Env.wrap(new Properties());
        }
    }

    public static GroupEnv newInstance() {
        return GroupEnv.newInstance(null, false);
    }

    public static GroupEnv newInstance(String name) {
        return GroupEnv.newInstance(name, false);
    }

    public static GroupEnv newInstance(boolean mutable) {
        return GroupEnv.newInstance(null, mutable);
    }

    public static GroupEnv newInstance(String name, boolean mutable) {
        return new GroupEnv(name, mutable);
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvFirst(Env env) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.remove(env);
            this.envList.add(0, env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvLast(Env env) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.remove(env);
            this.envList.add(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEnv(String name) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceEnv(String name, Env env) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.set(i, env);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEnvBefore(String name, Env env) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.add(i, env);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEnvAfter(String name, Env env) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.add(i + 1, env);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEnv() {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.clear();
        }
    }

    @Override
    public void set(String key, String value) {
        if (this.runtime != null) {
            this.runtime.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        if (this.isResolvingKey(key)) {
            return null;
        }
        try {
            Object object;
            this.pushResolveKey(key);
            String val = null;
            if (this.runtime != null) {
                val = this.runtime.get(key);
            }
            if (val == null) {
                Env env;
                object = this.envList.iterator();
                while (object.hasNext() && (val = (env = (Env)object.next()).get(key)) == null) {
                }
            }
            try {
                if (val != null) {
                    val = this.resolveRef(val);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = val;
            return object;
        }
        finally {
            this.pollResolveKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        if (this.isResolvingKey(key)) {
            return;
        }
        try {
            this.pushResolveKey(key);
            if (this.runtime != null) {
                this.runtime.remove(key);
            }
            for (Env env : this.envList) {
                env.remove(key);
            }
        }
        finally {
            this.pollResolveKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keys() {
        if (Boolean.TRUE.equals(this.retrieved.get())) {
            return Collections.emptySet();
        }
        this.retrieved.set(true);
        try {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (this.runtime != null) {
                keys.addAll(this.runtime.keys());
            }
            for (Env env : this.envList) {
                Set<String> keySet = env.keys();
                keys.addAll(keySet);
            }
            LinkedHashSet<String> linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            this.retrieved.remove();
        }
    }

    private boolean isResolvingKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        return queue != null && queue.contains(key);
    }

    private void pushResolveKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        if (queue == null) {
            queue = new ArrayDeque<String>();
            this.resolvedKeys.set(queue);
        }
        queue.offerFirst(key);
    }

    private void pollResolveKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        if (Objects.equals(queue.peekFirst(), key)) {
            queue.pollFirst();
        }
        if (queue.isEmpty()) {
            this.resolvedKeys.remove();
        }
    }

    @Override
    public String get(String key, String defaultVal) {
        String val = this.get(key);
        return val != null ? val : defaultVal;
    }

    public String getOrEmpty(String key) {
        String val = this.get(key);
        return val != null ? val : "";
    }

    public String getOrDefault(String key, String defaultVal) {
        String val = this.get(key);
        return val != null ? val : defaultVal;
    }

    public String getOrDefaultIfEmpty(String key, String defaultVal) {
        String val = this.get(key);
        return Strings.isNotEmpty(val) ? val : defaultVal;
    }

    public String getOrDefaultIfBlank(String key, String defaultVal) {
        String val = this.get(key);
        return Strings.isNotBlank(val) ? val : defaultVal;
    }

    public String resolveRef(String origin, Function<String, String> getter) {
        return Strings.resolvePlaceholders(origin, getter, false);
    }

    public String resolveRef(String origin) {
        return this.resolveRef(origin, this::get);
    }

    public String resolveRef(String origin, Map<String, String> map) {
        return this.resolveRef(origin, map::get);
    }

    public String resolveRef(String origin, Properties env) {
        return this.resolveRef(origin, env::getProperty);
    }

    private boolean isInvalidPropertyValue(String val) {
        return Strings.isBlank(val);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String val = this.get(key);
        return this.isInvalidPropertyValue(val) ? defaultVal : Booleans.parseBoolean(val);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultVal) {
        try {
            String val = this.get(key);
            return this.isInvalidPropertyValue(val) ? defaultVal : Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultVal) {
        try {
            String val = this.get(key);
            return this.isInvalidPropertyValue(val) ? defaultVal : Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public LocalDate getLocalDate(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalDate localDate = LocalDate.parse(val, DATE_FORMATTER);
        return localDate;
    }

    public LocalDateTime getLocalDateTime(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalDateTime localDate = LocalDateTime.parse(val, DATE_TIME_FORMATTER);
        return localDate;
    }

    public LocalTime getLocalTime(String key, String defaultVal) {
        String val = this.get(key, defaultVal);
        LocalTime localDate = LocalTime.parse(val, TIME_FORMATTER);
        return localDate;
    }

    public Date getDate(String key, String defaultVal) {
        LocalDate localDate = this.getLocalDate(key, defaultVal);
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public Timestamp getDateTime(String key, String defaultVal) {
        LocalDateTime localDateTime = this.getLocalDateTime(key, defaultVal);
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Timestamp.from(instant);
    }

    public Time getTime(String key, String defaultVal) {
        LocalDateTime localDateTime = this.getLocalTime(key, defaultVal).atDate(LocalDate.now());
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return new Time(instant.toEpochMilli());
    }

    public String[] getArray(String key) {
        return this.getArray(key, null);
    }

    public String[] getArray(String key, String[] defaultVal) {
        String val = this.get(key);
        return this.isInvalidPropertyValue(val) ? defaultVal : val.split("[,|\r\n]+");
    }
}

