/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import java.util.Objects;
import java.util.StringJoiner;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(String version) {
        String[] arr = version.replaceAll("[^.\\d]", "").split("\\.");
        String[] vs = new String[]{"0", "0", "0"};
        System.arraycopy(arr, 0, vs, 0, vs.length);
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            major = Integer.parseInt(vs[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            minor = Integer.parseInt(vs[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            patch = Integer.parseInt(vs[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int asInt() {
        return (this.major & 0xFF) << 24 | (this.minor & 0xFF) << 16 | this.patch & 0xFFFF;
    }

    public String toString() {
        return new StringJoiner(".").add(Objects.toString(this.major)).add(Objects.toString(this.minor)).add(Objects.toString(this.patch)).toString();
    }

    @Override
    public int compareTo(Version another) {
        return Version.compare(this, another);
    }

    public boolean after(Version another) {
        return Version.compare(this, another) > 0;
    }

    public boolean afterOrEquals(Version another) {
        return Version.compare(this, another) >= 0;
    }

    public boolean before(Version another) {
        return Version.compare(this, another) < 0;
    }

    public boolean beforeOrEquals(Version another) {
        return Version.compare(this, another) <= 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public static int compare(Version x, Version y) {
        if (x.major < y.major) {
            return -1;
        }
        if (x.major > y.major) {
            return 1;
        }
        if (x.minor < y.minor) {
            return -1;
        }
        if (x.minor > y.minor) {
            return 1;
        }
        if (x.patch < y.patch) {
            return -1;
        }
        if (x.patch > y.patch) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }
}

