/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.err;

import io.polaris.core.function.Executable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class Exceptions {
    public static <T extends Exception> T of(Throwable t, Class<T> type, Function<Throwable, T> builder) {
        if (t == null) {
            return (T)((Exception)builder.apply(t));
        }
        if (type.isAssignableFrom(t.getClass())) {
            return (T)((Exception)t);
        }
        while (t.getCause() != null) {
            if (!type.isAssignableFrom((t = t.getCause()).getClass())) continue;
            return (T)((Exception)t);
        }
        return (T)((Exception)builder.apply(t));
    }

    public static <T extends Exception> T of(Throwable t, Class<T> type, Supplier<T> builder) {
        if (t == null) {
            return (T)((Exception)builder.get());
        }
        if (type.isAssignableFrom(t.getClass())) {
            return (T)((Exception)t);
        }
        while (t.getCause() != null) {
            if (!type.isAssignableFrom((t = t.getCause()).getClass())) continue;
            return (T)((Exception)t);
        }
        return (T)((Exception)builder.get());
    }

    public static Throwable getRootCauseUntil(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        while (t.getCause() != null) {
            if (!predicate.test(t = t.getCause())) continue;
            return t;
        }
        return t;
    }

    public static Throwable getRootCauseSafelyUntil(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        HashSet<Throwable> set = new HashSet<Throwable>();
        while (t.getCause() != null && !set.contains(t)) {
            set.add(t);
            if (!predicate.test(t = t.getCause())) continue;
            return t;
        }
        return t;
    }

    public static Throwable getRootCause(@Nonnull Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static Throwable getRootCauseSafely(@Nonnull Throwable t) {
        HashSet<Throwable> set = new HashSet<Throwable>();
        while (t.getCause() != null && !set.contains(t)) {
            set.add(t);
            t = t.getCause();
        }
        return t;
    }

    public static Set<Throwable> getCausePath(@Nonnull Throwable t) {
        LinkedHashSet<Throwable> set = new LinkedHashSet<Throwable>();
        while (t != null && !set.contains(t)) {
            set.add(t);
            t = t.getCause();
        }
        return set;
    }

    public static Throwable hasCause(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        while (t != null) {
            if (predicate.test(t)) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    public static Throwable hasCause(@Nonnull Throwable t, Class<? extends Throwable> type) {
        while (t != null) {
            if (type.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static void quietlyClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void quietlyClose(AutoCloseable closeable, Throwable t) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
    }

    public static void runQuietly(Runnable runnable) {
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void runQuietly(Runnable runnable, Throwable t) {
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
    }

    public static <T> T getQuietly(Supplier<T> supplier) {
        if (supplier != null) {
            try {
                return supplier.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T getQuietly(Supplier<T> supplier, Throwable t) {
        if (supplier != null) {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
        return null;
    }

    public static void executeQuietly(Executable executable) {
        if (executable != null) {
            try {
                executable.execute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void executeQuietly(Executable executable, Throwable t) {
        if (executable != null) {
            try {
                executable.execute();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
    }

    public static <T> T callQuietly(Callable<T> callable) {
        if (callable != null) {
            try {
                return callable.call();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T callQuietly(Callable<T> callable, Throwable t) {
        if (callable != null) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
        return null;
    }
}

