/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.err;

import io.polaris.core.err.CheckedException;
import io.polaris.core.err.IErrorCode;
import io.polaris.core.msg.MessageResources;
import io.polaris.core.string.Strings;
import java.util.function.Supplier;

public class MessageCheckedException
extends CheckedException
implements IErrorCode {
    private static final long serialVersionUID = 1L;
    private String code;
    private String message;

    public MessageCheckedException() {
    }

    public MessageCheckedException(String message) {
        super(message);
    }

    public MessageCheckedException(String code, String message) {
        super(message);
        this.withCode(code, message);
    }

    public MessageCheckedException(Throwable cause) {
        super(cause);
        this.fetchCode(null, cause, null);
    }

    public MessageCheckedException(Throwable cause, String message) {
        super(message, cause);
        this.fetchCode(null, cause, message);
    }

    public MessageCheckedException(Throwable cause, String code, String message) {
        super(message, cause);
        this.fetchCode(code, cause, message);
    }

    public MessageCheckedException(Throwable cause, boolean enableSuppression, boolean writableStackTrace, String code, String message) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.fetchCode(code, cause, message);
    }

    private void fetchCode(String code, Throwable cause, String message) {
        if (code == null || code.trim().length() == 0) {
            if (cause instanceof IErrorCode) {
                this.withCode(((IErrorCode)((Object)cause)).getCode(), Strings.coalesce(message, cause.getMessage(), code));
            }
        } else {
            this.withCode(code, Strings.coalesce(message, cause.getMessage(), code));
        }
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public MessageCheckedException withCode(String code) {
        this.withCode(code, this.message);
        return this;
    }

    public MessageCheckedException withCode(String code, String defaultMessage) {
        this.code = code;
        if (code != null && code.length() > 0) {
            this.message = MessageResources.getDefaultMessageResource().getMessageOrDefault(code, defaultMessage, new Object[0]);
        }
        return this;
    }

    public MessageCheckedException withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String getMessage() {
        return this.message != null && this.message.length() > 0 ? this.message : super.getMessage();
    }

    public static MessageCheckedException of(Throwable t) {
        if (t == null) {
            return new MessageCheckedException();
        }
        if (t instanceof MessageCheckedException) {
            return (MessageCheckedException)t;
        }
        while (t.getCause() != null) {
            if (!((t = t.getCause()) instanceof MessageCheckedException)) continue;
            return (MessageCheckedException)t;
        }
        return new MessageCheckedException(t);
    }

    public static MessageCheckedException of(Throwable t, String message) {
        if (t == null) {
            return new MessageCheckedException(message);
        }
        if (t instanceof MessageCheckedException) {
            String msg = t.getMessage();
            if (msg == null) {
                ((MessageCheckedException)t).withMessage(message);
            } else if (!msg.startsWith(message)) {
                ((MessageCheckedException)t).withMessage(message + ": " + msg);
            }
            return (MessageCheckedException)t;
        }
        while (t.getCause() != null) {
            if (!((t = t.getCause()) instanceof MessageCheckedException)) continue;
            String msg = t.getMessage();
            if (msg == null) {
                ((MessageCheckedException)t).withMessage(message);
            } else if (!msg.startsWith(message)) {
                ((MessageCheckedException)t).withMessage(message + ": " + msg);
            }
            return (MessageCheckedException)t;
        }
        return new MessageCheckedException(t, message);
    }

    public static <T extends MessageCheckedException> T of(Throwable t, Class<T> type, String message, Supplier<T> builder) {
        if (t == null) {
            return (T)((MessageCheckedException)builder.get());
        }
        if (type.isAssignableFrom(t.getClass())) {
            if (MessageCheckedException.class.isAssignableFrom(type)) {
                String msg = t.getMessage();
                if (msg == null) {
                    ((MessageCheckedException)t).withMessage(message);
                } else if (!msg.startsWith(message)) {
                    ((MessageCheckedException)t).withMessage(message + ": " + msg);
                }
            }
            return (T)((MessageCheckedException)t);
        }
        while (t.getCause() != null) {
            if (!type.isAssignableFrom((t = t.getCause()).getClass())) continue;
            if (MessageCheckedException.class.isAssignableFrom(type)) {
                String msg = t.getMessage();
                if (msg == null) {
                    ((MessageCheckedException)t).withMessage(message);
                } else if (!msg.startsWith(message)) {
                    ((MessageCheckedException)t).withMessage(message + ": " + msg);
                }
            }
            return (T)((MessageCheckedException)t);
        }
        return (T)((MessageCheckedException)builder.get());
    }
}

