/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.guid;

import io.polaris.core.env.GlobalStdEnv;
import io.polaris.core.os.OS;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.channels.FileLock;

public class LocalNode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextNodeId(String appName, int bizSize) {
        if (bizSize <= 8 || bizSize > 16) {
            throw new IllegalArgumentException();
        }
        int nodeId = 0;
        String tmpdir = GlobalStdEnv.get("java.io.tmpdir");
        String file = tmpdir + "/.guid." + appName + ".lck";
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            FileLock lock = null;
            while (true) {
                try {
                    lock = raf.getChannel().lock();
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
            try {
                if (raf.length() >= 4L) {
                    nodeId = raf.readInt() + 1;
                    raf.seek(0L);
                    raf.writeInt(nodeId);
                } else {
                    raf.writeInt(nodeId);
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        catch (Throwable e) {
            System.err.println("cannot access file : " + file);
            e.printStackTrace(System.err);
        }
        int addr = 0;
        try {
            String firstIp = OS.getFirstIp();
            if (firstIp == null) {
                byte[] address = InetAddress.getLocalHost().getAddress();
                addr = address[address.length - 1];
            } else {
                String[] arr = firstIp.split("\\.");
                addr = Integer.parseInt(arr[arr.length - 1]);
            }
        }
        catch (Throwable e) {
            System.err.println("cannot read InetAddress!");
            e.printStackTrace(System.err);
        }
        return (addr & 0xFF) << bizSize - 8 | nodeId & (0xFFFFFFFF ^ -1 << bizSize - 8);
    }
}

