/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BeanCompositeMapping;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.BeanPropertyMapping;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.bean.CaseModeOption;
import io.polaris.core.lang.bean.MetaObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;

public class BeanMappings {
    public static <T> void setProperty(ResultSet rs, BeanMapping<T> mapping, CaseModeOption caseModel, T bean) throws SQLException {
        MetaObject<T> metaObject = mapping.getMetaObject();
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                MetaObject<?> valMeta = metaObject.getProperty(caseModel, beanPropertyMapping.getProperty());
                Object val = BeanMappings.getResultValue(rs, beanPropertyMapping.getColumn(), valMeta);
                if (val == null) continue;
                metaObject.setProperty(bean, caseModel, beanPropertyMapping.getProperty(), val);
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                String subProperty = beanCompositeMapping.getProperty();
                BeanMapping subMapping = beanCompositeMapping.getMapping();
                MetaObject subMetaObject = subMapping.getMetaObject();
                if (subMetaObject == null) continue;
                Object subBean = metaObject.getProperty(bean, caseModel, subProperty);
                if (subBean == null) {
                    subBean = subMetaObject.newInstance();
                    metaObject.setProperty(bean, caseModel, subProperty, subBean);
                }
                BeanMappings.setProperty(rs, subMapping, caseModel, subBean);
            }
        }
    }

    public static <T> void removeMappingCols(Map<String, Integer> resultCols, BeanMapping<T> mapping) {
        if (mapping == null) {
            return;
        }
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                resultCols.remove(beanPropertyMapping.getColumn());
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                BeanMappings.removeMappingCols(resultCols, beanCompositeMapping.getMapping());
            }
        }
    }

    public static <T> void markMappingCols(Map<String, Boolean> resultCols, BeanMapping<T> mapping) {
        if (mapping == null) {
            return;
        }
        if (mapping.getColumns() != null) {
            for (BeanPropertyMapping beanPropertyMapping : mapping.getColumns()) {
                if (!resultCols.containsKey(beanPropertyMapping.getColumn())) continue;
                resultCols.put(beanPropertyMapping.getColumn(), true);
            }
        }
        if (mapping.getComposites() != null) {
            for (BeanCompositeMapping beanCompositeMapping : mapping.getComposites()) {
                BeanMappings.markMappingCols(resultCols, beanCompositeMapping.getMapping());
            }
        }
    }

    public static Object getResultValue(ResultSet rs, int column, MetaObject<?> meta) throws SQLException {
        if (meta == null) {
            return rs.getObject(column);
        }
        JavaType<?> beanType = meta.getBeanType();
        Class<?> clazz = beanType.getRawClass();
        return BeanMappings.getResultValue(rs, column, clazz);
    }

    public static Object getResultValue(ResultSet rs, String column, MetaObject<?> meta) throws SQLException {
        if (meta == null) {
            return rs.getObject(column);
        }
        JavaType<?> beanType = meta.getBeanType();
        Class<?> clazz = beanType.getRawClass();
        return BeanMappings.getResultValue(rs, column, clazz);
    }

    public static Object getResultValue(ResultSet rs, int col, Type type) throws SQLException {
        if (type == null) {
            return rs.getObject(col);
        }
        Class<?> clazz = Types.getClass(type);
        if (clazz.equals(Object.class)) {
            return rs.getObject(col);
        }
        if (clazz.equals(String.class) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz)) {
            return rs.getString(col);
        }
        if (clazz.equals(Integer.TYPE)) {
            return rs.getInt(col);
        }
        if (clazz.equals(Integer.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.intValue();
        }
        if (clazz.equals(Long.TYPE)) {
            return rs.getLong(col);
        }
        if (clazz.equals(Long.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.longValue();
        }
        if (clazz.equals(Boolean.TYPE)) {
            return rs.getBoolean(col);
        }
        if (clazz.equals(Boolean.class)) {
            String val = rs.getString(col);
            if (val == null) {
                return null;
            }
            return rs.getBoolean(col);
        }
        if (clazz.equals(Double.TYPE)) {
            return rs.getDouble(col);
        }
        if (clazz.equals(Double.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.doubleValue();
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(rs.getFloat(col));
        }
        if (clazz.equals(Float.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return Float.valueOf(val.floatValue());
        }
        if (clazz.equals(Byte.TYPE)) {
            return rs.getByte(col);
        }
        if (clazz.equals(Byte.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.byteValue();
        }
        if (clazz.equals(Short.TYPE)) {
            return rs.getShort(col);
        }
        if (clazz.equals(Short.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.shortValue();
        }
        if (clazz.equals(Character.TYPE)) {
            String val = rs.getString(col);
            return Character.valueOf(val == null || val.isEmpty() ? (char)'\u0000' : val.charAt(0));
        }
        if (clazz.equals(Character.class)) {
            String val = rs.getString(col);
            return val == null || val.isEmpty() ? null : Character.valueOf(val.charAt(0));
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return rs.getBigDecimal(col);
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return rs.getBytes(col);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return rs.getTimestamp(col);
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return rs.getTime(col);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return rs.getDate(col);
        }
        if (TemporalAccessor.class.isAssignableFrom(clazz)) {
            return rs.getTimestamp(col);
        }
        try {
            return rs.getObject(col, clazz);
        }
        catch (Throwable e) {
            return rs.getObject(col);
        }
    }

    public static Object getResultValue(ResultSet rs, String col, Type type) throws SQLException {
        if (type == null) {
            return rs.getObject(col);
        }
        Class<?> clazz = Types.getClass(type);
        if (clazz.equals(Object.class)) {
            return rs.getObject(col);
        }
        if (clazz.equals(String.class) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz)) {
            return rs.getString(col);
        }
        if (clazz.equals(Integer.TYPE)) {
            return rs.getInt(col);
        }
        if (clazz.equals(Integer.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.intValue();
        }
        if (clazz.equals(Long.TYPE)) {
            return rs.getLong(col);
        }
        if (clazz.equals(Long.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.longValue();
        }
        if (clazz.equals(Boolean.TYPE)) {
            return rs.getBoolean(col);
        }
        if (clazz.equals(Boolean.class)) {
            String val = rs.getString(col);
            if (val == null) {
                return null;
            }
            return rs.getBoolean(col);
        }
        if (clazz.equals(Double.TYPE)) {
            return rs.getDouble(col);
        }
        if (clazz.equals(Double.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.doubleValue();
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(rs.getFloat(col));
        }
        if (clazz.equals(Float.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return Float.valueOf(val.floatValue());
        }
        if (clazz.equals(Byte.TYPE)) {
            return rs.getByte(col);
        }
        if (clazz.equals(Byte.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.byteValue();
        }
        if (clazz.equals(Short.TYPE)) {
            return rs.getShort(col);
        }
        if (clazz.equals(Short.class)) {
            BigDecimal val = rs.getBigDecimal(col);
            if (val == null) {
                return null;
            }
            return val.shortValue();
        }
        if (clazz.equals(Character.TYPE)) {
            String val = rs.getString(col);
            return Character.valueOf(val == null || val.isEmpty() ? (char)'\u0000' : val.charAt(0));
        }
        if (clazz.equals(Character.class)) {
            String val = rs.getString(col);
            return val == null || val.isEmpty() ? null : Character.valueOf(val.charAt(0));
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return rs.getBigDecimal(col);
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return rs.getBytes(col);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return rs.getTimestamp(col);
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return rs.getTime(col);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return rs.getDate(col);
        }
        if (TemporalAccessor.class.isAssignableFrom(clazz)) {
            return rs.getTimestamp(col);
        }
        try {
            return rs.getObject(col, clazz);
        }
        catch (Throwable e) {
            return rs.getObject(col);
        }
    }
}

