/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.annotation.Options;
import io.polaris.core.jdbc.base.DefaultParameterPreparer;
import io.polaris.core.jdbc.base.ParameterPreparer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class JdbcOptions {
    private static final Map<Class<? extends ParameterPreparer>, ParameterPreparer> caches = new ConcurrentHashMap<Class<? extends ParameterPreparer>, ParameterPreparer>();
    private boolean useGeneratedKeys = false;
    private int fetchSize = 100;
    private int timeout = -1;
    private int maxRows = -1;
    private String[] keyProperties;
    private String[] keyColumns;
    private ParameterPreparer parameterPreparer = DefaultParameterPreparer.INSTANCE;

    public static JdbcOptions ofDefault() {
        return new JdbcOptions();
    }

    public static JdbcOptions of(@Nullable Options options) {
        JdbcOptions jdbcOptions = new JdbcOptions();
        if (options != null) {
            jdbcOptions.setUseGeneratedKeys(options.useGeneratedKeys());
            jdbcOptions.setFetchSize(options.fetchSize());
            jdbcOptions.setTimeout(options.timeout());
            jdbcOptions.setKeyProperties(options.keyProperty());
            jdbcOptions.setKeyColumns(options.keyColumn());
            Class<? extends ParameterPreparer> clazz = options.parameterPreparer();
            if (clazz == DefaultParameterPreparer.class) {
                jdbcOptions.setParameterPreparer(DefaultParameterPreparer.INSTANCE);
            } else {
                ParameterPreparer preparer = caches.computeIfAbsent(clazz, k -> {
                    try {
                        return (ParameterPreparer)k.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                jdbcOptions.setParameterPreparer(preparer);
            }
        }
        return jdbcOptions;
    }

    public boolean isUseGeneratedKeys() {
        return this.useGeneratedKeys;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String[] getKeyProperties() {
        return this.keyProperties;
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public ParameterPreparer getParameterPreparer() {
        return this.parameterPreparer;
    }

    public void setUseGeneratedKeys(boolean useGeneratedKeys) {
        this.useGeneratedKeys = useGeneratedKeys;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setKeyProperties(String[] keyProperties) {
        this.keyProperties = keyProperties;
    }

    public void setKeyColumns(String[] keyColumns) {
        this.keyColumns = keyColumns;
    }

    public void setParameterPreparer(ParameterPreparer parameterPreparer) {
        this.parameterPreparer = parameterPreparer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcOptions)) {
            return false;
        }
        JdbcOptions other = (JdbcOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.useGeneratedKeys != other.useGeneratedKeys) {
            return false;
        }
        if (this.fetchSize != other.fetchSize) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        if (this.maxRows != other.maxRows) {
            return false;
        }
        if (!Arrays.deepEquals(this.keyProperties, other.keyProperties)) {
            return false;
        }
        if (!Arrays.deepEquals(this.keyColumns, other.keyColumns)) {
            return false;
        }
        ParameterPreparer this$parameterPreparer = this.parameterPreparer;
        ParameterPreparer other$parameterPreparer = other.parameterPreparer;
        return !(this$parameterPreparer == null ? other$parameterPreparer != null : !this$parameterPreparer.equals(other$parameterPreparer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.useGeneratedKeys ? 79 : 97);
        result = result * 59 + this.fetchSize;
        result = result * 59 + this.timeout;
        result = result * 59 + this.maxRows;
        result = result * 59 + Arrays.deepHashCode(this.keyProperties);
        result = result * 59 + Arrays.deepHashCode(this.keyColumns);
        ParameterPreparer $parameterPreparer = this.parameterPreparer;
        result = result * 59 + ($parameterPreparer == null ? 43 : $parameterPreparer.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcOptions(useGeneratedKeys=" + this.useGeneratedKeys + ", fetchSize=" + this.fetchSize + ", timeout=" + this.timeout + ", maxRows=" + this.maxRows + ", keyProperties=" + Arrays.deepToString(this.keyProperties) + ", keyColumns=" + Arrays.deepToString(this.keyColumns) + ", parameterPreparer=" + this.parameterPreparer + ")";
    }

    static {
        caches.put(DefaultParameterPreparer.class, DefaultParameterPreparer.INSTANCE);
    }
}

