/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BaseResultRowMapper;
import io.polaris.core.jdbc.base.BeanMappings;
import io.polaris.core.lang.bean.CaseModeOption;
import io.polaris.core.lang.bean.MetaObject;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultRowBeanMapper<T>
extends BaseResultRowMapper<T> {
    private final MetaObject<T> metaObject;
    private final CaseModeOption caseMode;

    public ResultRowBeanMapper(Class<T> beanType) {
        this(beanType, CaseModeOption.all());
    }

    public ResultRowBeanMapper(Class<T> beanType, CaseModeOption caseMode) {
        this.metaObject = MetaObject.of(beanType);
        this.caseMode = caseMode;
    }

    public ResultRowBeanMapper(Type beanType) {
        this(beanType, CaseModeOption.all());
    }

    public ResultRowBeanMapper(Type beanType, CaseModeOption caseMode) {
        this.metaObject = MetaObject.of(beanType);
        this.caseMode = caseMode;
    }

    @Override
    protected T doMap(ResultSet rs, String[] columns) throws SQLException {
        T bean = this.metaObject.newInstance();
        if (bean != null) {
            for (int i = 1; i <= columns.length; ++i) {
                String key = columns[i - 1];
                MetaObject<?> valMeta = this.metaObject.getPathProperty(this.caseMode, key);
                Object val = BeanMappings.getResultValue(rs, i, valMeta);
                this.metaObject.setPathProperty(bean, this.caseMode, key, val);
            }
        }
        return bean;
    }
}

