/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.base;

import io.polaris.core.jdbc.base.BaseResultRowMapper;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.BeanMappings;
import io.polaris.core.lang.bean.CaseModeOption;
import io.polaris.core.lang.bean.MetaObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResultRowBeanMappingMapper<T>
extends BaseResultRowMapper<T> {
    private final BeanMapping<T> mapping;
    private String[] colsLast;
    private Map<String, Integer> unmappedCols;

    public ResultRowBeanMappingMapper(BeanMapping<T> mapping) {
        mapping.prepare();
        this.mapping = mapping;
    }

    @Override
    protected T doMap(ResultSet rs, String[] columns) throws SQLException {
        if (this.colsLast != columns) {
            HashMap<String, Integer> cols = new HashMap<String, Integer>();
            for (int i = 1; i <= columns.length; ++i) {
                cols.put(columns[i - 1], i);
            }
            BeanMappings.removeMappingCols(cols, this.mapping);
            this.unmappedCols = Collections.unmodifiableMap(cols);
            this.colsLast = columns;
        }
        CaseModeOption caseModel = this.mapping.getCaseMode();
        T bean = this.mapping.getMetaObject().newInstance();
        if (bean != null) {
            for (Map.Entry<String, Integer> entry : this.unmappedCols.entrySet()) {
                String key = entry.getKey();
                Integer columnIndex = entry.getValue();
                MetaObject<?> valMeta = this.mapping.getMetaObject().getPathProperty(caseModel, key);
                Object val = BeanMappings.getResultValue(rs, (int)columnIndex, valMeta);
                this.mapping.getMetaObject().setPathProperty(bean, caseModel, key, val);
            }
        }
        BeanMappings.setProperty(rs, this.mapping, caseModel, bean);
        return bean;
    }
}

