/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.dialect;

import io.polaris.core.jdbc.JdbcDriver;
import io.polaris.core.jdbc.dialect.Db2AS400Dialect;
import io.polaris.core.jdbc.dialect.Db2Dialect;
import io.polaris.core.jdbc.dialect.Dialect;
import io.polaris.core.jdbc.dialect.HsqldbDialect;
import io.polaris.core.jdbc.dialect.InformixDialect;
import io.polaris.core.jdbc.dialect.MysqlDialect;
import io.polaris.core.jdbc.dialect.OracleDialect;
import io.polaris.core.jdbc.dialect.PostgresqlDialect;
import io.polaris.core.jdbc.dialect.SqlserverDialect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class Dialects {
    private static final Map<JdbcDriver, Dialect> dialects = new ConcurrentHashMap<JdbcDriver, Dialect>();

    @Nullable
    public static Dialect getDialect(JdbcDriver driver) {
        return dialects.get((Object)driver);
    }

    public static void registerDialect(JdbcDriver driver, Dialect dialect) {
        dialects.put(driver, dialect);
    }

    static {
        dialects.put(JdbcDriver.ORACLE, new OracleDialect());
        dialects.put(JdbcDriver.SQLSERVER, new SqlserverDialect());
        dialects.put(JdbcDriver.MYSQL, new MysqlDialect());
        dialects.put(JdbcDriver.POSTGRESQL, new PostgresqlDialect());
        dialects.put(JdbcDriver.HSQLDB, new HsqldbDialect());
        dialects.put(JdbcDriver.INFORMIX, new InformixDialect());
        dialects.put(JdbcDriver.DB2, new Db2Dialect());
        dialects.put(JdbcDriver.DB2_AS400, new Db2AS400Dialect());
    }
}

