/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.executor;

import io.polaris.core.collection.PrimitiveArrays;
import io.polaris.core.jdbc.annotation.EntitySelect;
import io.polaris.core.jdbc.annotation.Key;
import io.polaris.core.jdbc.annotation.Mapping;
import io.polaris.core.jdbc.annotation.Options;
import io.polaris.core.jdbc.annotation.SqlQuery;
import io.polaris.core.jdbc.annotation.SqlSelect;
import io.polaris.core.jdbc.annotation.SqlSelectSet;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.JdbcOptions;
import io.polaris.core.jdbc.base.ResultBeanCollectionExtractor;
import io.polaris.core.jdbc.base.ResultBeanExtractor;
import io.polaris.core.jdbc.base.ResultBeanMappingCollectionExtractor;
import io.polaris.core.jdbc.base.ResultBeanMappingExtractor;
import io.polaris.core.jdbc.base.ResultExtractor;
import io.polaris.core.jdbc.base.ResultMapCollectionExtractor;
import io.polaris.core.jdbc.base.ResultMapExtractor;
import io.polaris.core.jdbc.base.ResultRowMapper;
import io.polaris.core.jdbc.base.ResultRowMappers;
import io.polaris.core.jdbc.base.ResultSingleCollectionExtractor;
import io.polaris.core.jdbc.base.ResultSingleExtractor;
import io.polaris.core.jdbc.base.ResultVisitor;
import io.polaris.core.jdbc.executor.MappingModel;
import io.polaris.core.jdbc.executor.MethodArgs;
import io.polaris.core.jdbc.executor.MethodMetadata;
import io.polaris.core.jdbc.sql.EntityStatements;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.CaseModeOption;
import io.polaris.core.map.Maps;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class JdbcExecutorMetadata<T> {
    private static final Map<Class<?>, JdbcExecutorMetadata<?>> metabaseCache = Maps.newSoftMap(new ConcurrentHashMap());
    private final Map<Method, MethodMetadata> methodMetadataMap;

    protected JdbcExecutorMetadata(Class<T> interfaceClass) {
        Method[] methods;
        HashMap<Method, MethodMetadata> methodMetadataMap = new HashMap<Method, MethodMetadata>();
        for (Method method : methods = interfaceClass.getMethods()) {
            if (method.isDefault() || Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isPrivate(method.getModifiers()) || Reflects.isObjectDeclaredMethod(method)) continue;
            methodMetadataMap.put(method, this.parseMethodMetadata(method));
        }
        this.methodMetadataMap = Collections.unmodifiableMap(methodMetadataMap);
    }

    public static <T> JdbcExecutorMetadata<T> of(Class<T> interfaceClass) {
        return metabaseCache.computeIfAbsent(interfaceClass, k -> new JdbcExecutorMetadata(interfaceClass));
    }

    public Map<Method, MethodMetadata> getMethodMetadataMap() {
        return this.methodMetadataMap;
    }

    private MethodMetadata parseMethodMetadata(Method method) {
        ResultExtractor<Object> extractor;
        JavaType returnType = JavaType.of(method.getGenericReturnType());
        MappingModel mappingModel = MappingModel.of(method.getAnnotation(Mapping.class));
        BeanMapping<?> beanMapping = mappingModel.getBeanMapping();
        Function<Object[], MethodArgs> argsBuilder = this.parseArgsBuilder(method, beanMapping);
        Tuple2<Boolean, Function<Map<String, Object>, SqlNode>> sqlBuilderTuple = JdbcExecutorMetadata.parseSqlBuilder(method);
        Function<Map<String, Object>, SqlNode> sqlBuilder = sqlBuilderTuple.getSecond();
        if (!sqlBuilderTuple.getFirst().booleanValue()) {
            return new MethodMetadata(returnType, false, argsBuilder, sqlBuilder, null);
        }
        CaseModeOption caseMode = mappingModel.getCaseMode();
        if (Void.TYPE.equals(returnType.getRawClass())) {
            extractor = null;
        } else if (Collection.class.isAssignableFrom(returnType.getRawClass())) {
            Type actualType = returnType.getActualType(Collection.class, 0);
            Class elementType = JavaType.of(actualType).getRawClass();
            Supplier<Collection> collBuilder = () -> (Collection)Reflects.newInstanceIfPossible(returnType.getRawClass());
            extractor = beanMapping != null && elementType.isAssignableFrom(beanMapping.getMetaObject().getBeanType().getRawClass()) ? new ResultBeanMappingCollectionExtractor(collBuilder, beanMapping) : (Beans.isBeanClass(elementType) ? new ResultBeanCollectionExtractor(collBuilder, elementType, mappingModel.getCaseMode()) : (Map.class.isAssignableFrom(elementType) ? new ResultMapCollectionExtractor(collBuilder, elementType) : new ResultSingleCollectionExtractor<Collection>(collBuilder, elementType)));
        } else {
            Class elementType = returnType.getRawClass();
            extractor = beanMapping != null && elementType.isAssignableFrom(beanMapping.getMetaObject().getBeanType().getRawClass()) ? new ResultBeanMappingExtractor(beanMapping) : (Beans.isBeanClass(elementType) ? new ResultBeanExtractor(elementType) : (Map.class.isAssignableFrom(elementType) ? new ResultMapExtractor(elementType) : new ResultSingleExtractor(elementType)));
        }
        return new MethodMetadata(returnType, true, argsBuilder, sqlBuilder, extractor);
    }

    private Function<Object[], MethodArgs> parseArgsBuilder(Method method, BeanMapping<?> beanMapping) {
        ResultRowMapper<Map<String, Object>> resultRowMapper;
        Type[] parameterTypes = method.getGenericParameterTypes();
        Parameter[] parameters = method.getParameters();
        int parameterCount = parameterTypes.length;
        int[] specIndex = new int[]{-1, -1, -1, -1};
        String[] keys = new String[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            Parameter parameter = parameters[i];
            JavaType parameterType = JavaType.of(parameterTypes[i]);
            if (Connection.class.isAssignableFrom(parameterType.getRawClass())) {
                specIndex[0] = i;
                continue;
            }
            if (ResultExtractor.class.isAssignableFrom(parameterType.getRawClass())) {
                specIndex[1] = i;
                continue;
            }
            if (ResultVisitor.class.isAssignableFrom(parameterType.getRawClass())) {
                specIndex[2] = i;
                continue;
            }
            String key = JdbcExecutorMetadata.getParameterName(parameter);
            if (key == null) {
                if (specIndex[3] >= 0) {
                    throw new IllegalArgumentException("\u4e0d\u80fd\u5b58\u5728\u591a\u4e2a\u672a\u6307\u5b9a\u53c2\u6570\u540d\u7684\u53c2\u6570");
                }
                specIndex[3] = i;
                continue;
            }
            keys[i] = key;
        }
        if (specIndex[2] >= 0) {
            JavaType parameterType = JavaType.of(parameterTypes[specIndex[2]]);
            JavaType actualType = JavaType.of(parameterType.getActualType(ResultVisitor.class, 0));
            Class rawClass = actualType.getRawClass();
            resultRowMapper = beanMapping != null && rawClass.isAssignableFrom(beanMapping.getMetaObject().getBeanType().getRawClass()) ? ResultRowMappers.ofMapping(beanMapping) : (Object.class.equals(rawClass) ? ResultRowMappers.ofMap() : (Map.class.isAssignableFrom(rawClass) ? ResultRowMappers.ofMap(rawClass) : (Beans.isBeanClass(rawClass) ? ResultRowMappers.ofBean(actualType) : ResultRowMappers.ofSingle(actualType))));
        } else {
            resultRowMapper = null;
        }
        JdbcOptions options = JdbcOptions.of(method.getAnnotation(Options.class));
        return args -> {
            Connection conn = null;
            if (specIndex[0] >= 0) {
                conn = (Connection)args[specIndex[0]];
            }
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            ResultExtractor extractor = null;
            ResultVisitor visitor = null;
            Object noKeyArg = null;
            if (specIndex[1] >= 0) {
                extractor = (ResultExtractor)args[specIndex[1]];
            }
            if (specIndex[2] >= 0) {
                visitor = (ResultVisitor)args[specIndex[2]];
            }
            if (specIndex[3] >= 0) {
                noKeyArg = args[specIndex[3]];
                if (noKeyArg instanceof Map) {
                    ((Map)noKeyArg).forEach(bindings::putIfAbsent);
                } else {
                    Beans.newBeanMap(noKeyArg).forEach(bindings::putIfAbsent);
                }
            }
            for (int i = 0; i < parameterCount; ++i) {
                if (PrimitiveArrays.contains(specIndex, i)) continue;
                bindings.put(keys[i], args[i]);
            }
            return new MethodArgs(options, conn, bindings, noKeyArg, extractor, visitor, resultRowMapper);
        };
    }

    private static Tuple2<Boolean, Function<Map<String, Object>, SqlNode>> parseSqlBuilder(Method method) {
        boolean isSelect;
        boolean bl = isSelect = method.isAnnotationPresent(SqlQuery.class) || method.isAnnotationPresent(EntitySelect.class) || method.isAnnotationPresent(SqlSelect.class) || method.isAnnotationPresent(SqlSelectSet.class);
        if (isSelect) {
            return Tuple2.of(true, EntityStatements.buildSqlSelectFunction(method));
        }
        return Tuple2.of(false, EntityStatements.buildSqlUpdateFunction(method));
    }

    private static String getParameterName(Parameter parameter) {
        Key key = parameter.getAnnotation(Key.class);
        if (key != null) {
            return Strings.trimToNull(key.value());
        }
        for (Annotation annotation : parameter.getAnnotations()) {
            if (!"org.apache.ibatis.annotations.Param".equals(annotation.annotationType().getName())) continue;
            return Strings.trimToNull(AnnotationAttributes.of(annotation).getString("value"));
        }
        return null;
    }
}

