/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.executor;

import io.polaris.core.jdbc.annotation.Mapping;
import io.polaris.core.jdbc.base.BeanCompositeMapping;
import io.polaris.core.jdbc.base.BeanMapping;
import io.polaris.core.jdbc.base.BeanPropertyMapping;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.bean.CaseModeOption;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import javax.annotation.Nullable;

public class MappingModel {
    private static final String PROPERTY = Reflects.getPropertyName(Mapping.Composite::property);
    private static final String ENTITY_TYPE = Reflects.getPropertyName(Mapping.Composite::entityType);
    private static final String COLUMNS = Reflects.getPropertyName(Mapping.Composite::columns);
    private static final String COMPOSITES = Reflects.getPropertyName(Mapping.Composite::composites);
    private CaseModeOption caseMode = CaseModeOption.all();
    private BeanMapping<?> beanMapping;

    public static MappingModel of(@Nullable Mapping mapping) {
        MappingModel model = new MappingModel();
        if (mapping != null) {
            Class<?> entityType = mapping.entityType();
            if (entityType != Void.TYPE) {
                Mapping.Composite[] composites;
                BeanMapping beanMapping = new BeanMapping(entityType);
                model.beanMapping = beanMapping;
                for (Mapping.Column column : mapping.columns()) {
                    beanMapping.column(new BeanPropertyMapping(column.property(), column.column()));
                }
                for (Mapping.Composite composite : composites = mapping.composites()) {
                    AnnotationAttributes attributes = AnnotationAttributes.of(composite);
                    MappingModel.fillComposite(beanMapping, attributes);
                }
            }
            model.caseMode = CaseModeOption.of(mapping.caseModes());
        }
        return model;
    }

    private static void fillComposite(BeanMapping<?> beanMapping, AnnotationAttributes attributes) {
        String property = attributes.getString(PROPERTY);
        Class entityType = attributes.getClass(ENTITY_TYPE);
        if (Strings.isNotBlank(property) && entityType != Void.TYPE) {
            AnnotationAttributes[] composites;
            Mapping.Column[] columns;
            BeanMapping subMapping = new BeanMapping(entityType);
            beanMapping.composite(new BeanCompositeMapping(property, subMapping));
            for (Mapping.Column column : columns = (Mapping.Column[])attributes.getAnnotationArray(COLUMNS, Mapping.Column.class)) {
                subMapping.column(new BeanPropertyMapping(column.property(), column.column()));
            }
            for (AnnotationAttributes composite : composites = attributes.getAnnotationAttributesArray(COMPOSITES)) {
                MappingModel.fillComposite(subMapping, composite);
            }
        }
    }

    public CaseModeOption getCaseMode() {
        return this.caseMode;
    }

    public BeanMapping<?> getBeanMapping() {
        return this.beanMapping;
    }
}

