/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.executor;

import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.base.JdbcOptions;
import io.polaris.core.jdbc.executor.BatchResult;
import io.polaris.core.jdbc.executor.JdbcBatch;
import io.polaris.core.jdbc.executor.JdbcBatchExecutor;
import io.polaris.core.jdbc.executor.JdbcExecutor;
import io.polaris.core.jdbc.executor.JdbcExecutors;
import io.polaris.core.jdbc.executor.MethodArgs;
import io.polaris.core.jdbc.executor.MethodMetadata;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.lang.JavaType;
import io.polaris.core.reflect.Reflects;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StatefulJdbcExecutor<T>
extends JdbcExecutor<T>
implements JdbcBatchExecutor {
    private final Connection connection;
    private final JdbcBatch batch;

    protected StatefulJdbcExecutor(Class<T> interfaceClass, Connection connection, boolean batch) {
        super(interfaceClass);
        this.connection = connection;
        this.batch = batch ? new JdbcBatch() : null;
    }

    @Override
    protected Connection getConnection(MethodArgs methodArgs) {
        Connection conn = methodArgs.getConnection();
        if (conn == null) {
            conn = this.connection;
        }
        if (conn == null) {
            conn = JdbcExecutors.getCurrentConnection();
        }
        if (conn != null) {
            return conn;
        }
        throw new IllegalArgumentException("\u7f3a\u5c11\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61");
    }

    @Override
    protected Function<Object[], Object> buildMethodFunction(MethodMetadata meta) {
        if (this.batch == null) {
            return super.buildMethodFunction(meta);
        }
        if (meta.isSelect()) {
            return this.buildSelectFunction(meta);
        }
        return args -> {
            try {
                MethodArgs methodArgs = meta.getArgsBuilder().apply((Object[])args);
                Map<String, Object> bindings = methodArgs.getBindings();
                SqlNode sqlNode = meta.getSqlBuilder().apply(bindings);
                JdbcOptions options = methodArgs.getOptions();
                Map<String, Object> noKeyArg = methodArgs.getNoKeyArg();
                Connection conn = this.getConnection(methodArgs);
                this.batch.update(conn, sqlNode, options, noKeyArg != null ? noKeyArg : bindings);
                JavaType<?> returnType = meta.getReturnType();
                if (Void.TYPE.equals(returnType.getRawClass())) {
                    return null;
                }
                return Converters.convertQuietly(returnType, -1);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == JdbcBatchExecutor.class) {
            return Reflects.invoke(this, method, args);
        }
        return super.invoke(proxy, method, args);
    }

    @Override
    public List<BatchResult> flush() throws SQLException {
        if (this.batch != null) {
            return this.batch.flush();
        }
        return null;
    }
}

